/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemRoot;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsStartMode;
import com.xebialabs.deployit.plugin.wls.ci.WlsVersion;
import com.xebialabs.deployit.plugin.wls.step.CheckWlsServerIsOnCluster;
import com.xebialabs.deployit.plugin.wls.step.DetectBrokenWlstStep;
import com.xebialabs.deployit.plugin.wls.step.RetrieveWlsDomainStep;
import com.xebialabs.deployit.plugin.wls.step.RetrieveWlsSubtypesStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDomainCheckReachableStep;
import com.xebialabs.deployit.plugin.wls.step.WlstDirectoryObjectInfoCollectingCallbackHandler;
import com.xebialabs.deployit.plugin.wls.step.WlstObjectInfoCollectingCallbackHandler;
import com.xebialabs.deployit.plugin.wls.step.WlstObjectInfoCollectingCallbackHandlerBase;
import com.xebialabs.deployit.step.CheckDirExistsStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@ConfigurationItem(root=ConfigurationItemRoot.INFRASTRUCTURE, category="middleware", discoverable=true, description="A WebLogic Domain.")
public class WlsDomain
extends BaseConfigurationItem
implements Discoverable<WlsDomain> {
    private static final String WLS_SERVER_KEY = "WlsServer";
    private static final String WLS_CLUSTER_KEY = "WlsCluster";
    protected static final String GET_OBJECT_BY_CONTAINMENT_PATH_SCRIPT = "com/xebialabs/deployit/plugin/wls/step/get-object-by-containment-path.py";
    @ConfigurationItemProperty(required=true, identifying=true, description="Name of the WebLogic Domain")
    private String name;
    @ConfigurationItemProperty(required=true, label="WebLogic home", description="The location of the WebLogic Server installation", size=ConfigurationItemProperty.Size.LARGE, discoveryParam=true)
    private String wlHome;
    @ConfigurationItemProperty(required=false, label="WebLogic domain home", description="The location of the WebLogic domain. Defaults to '<WebLogicHome>/../user_projects/domains/<Name>'", size=ConfigurationItemProperty.Size.LARGE)
    private String domainHome;
    @ConfigurationItemProperty(required=true, label="Administrative server port", description="Port to be used by the AdminServer for this domain", size=ConfigurationItemProperty.Size.SMALL, discoveryParam=true)
    private int port;
    @ConfigurationItemProperty(required=true, label="Administrative username", description="Username which is used to login to the WebLogic Domain.", discoveryParam=true)
    private String username;
    @ConfigurationItemProperty(required=true, label="Administrative password", password=true, description="Password which is used to login to the WebLogic Domain.", discoveryParam=true)
    private String password;
    @ConfigurationItemProperty(required=true, description="The name of the admin server")
    private String adminServerName;
    @ConfigurationItemProperty(required=true, label="Host", description="The host that runs the admin server")
    private Host activeHost;
    @ConfigurationItemProperty(required=true, label="Start Mode", description="Tells how a managed server is start and stop, default is NodeManager, others are Script or Windows Service")
    private WlsStartMode startMode = WlsStartMode.NodeManager;
    @ConfigurationItemProperty(label="Enable wlst.sh workaround", description="Enable workaround for broken wlst.sh script found in some versions of WLS")
    private boolean enableWlstShWorkaround;
    @ConfigurationItemProperty
    private WlsVersion wlsVersion = WlsVersion.WEBLOGIC_10;
    private static final Logger logger = LoggerFactory.getLogger(WlsDomain.class);

    public HostSession connectToAdminHost() {
        return HostSessionFactory.getHostSession((Host)this.activeHost);
    }

    public int executeWlstJythonScript(CommandExecutionCallbackHandler handler, HostSession s, String scriptPath, String ... args) {
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.isEnableWlstShWorkaround() && this.getActiveHost().getOperatingSystemFamily() == OperatingSystemFamily.UNIX) {
            logger.info("Workaround for broken wlst.sh is enabled for " + (Object)((Object)this) + ". Uploading wlst.sh from Deployit distribution");
            HostFile uploadedWlstSh = s.copyToTemporaryFile((Resource)new ClassPathResource("com/xebialabs/deployit/plugin/wls/wlst.sh"));
            cmd.add("/bin/sh");
            cmd.add(uploadedWlstSh.getPath());
            cmd.add(this.getWlHome());
        } else {
            cmd.add(this.getWlstPath());
        }
        cmd.add("-i");
        cmd.add(scriptPath);
        for (String arg : args) {
            cmd.add(arg);
        }
        String[] cmdArray = cmd.toArray(new String[cmd.size()]);
        return s.execute(handler, cmdArray);
    }

    public String getWlstPath() {
        String fileSeparator = this.getActiveHost().getFileSeparator();
        String wlstExtension = this.getActiveHost().getOperatingSystemFamily() == OperatingSystemFamily.WINDOWS ? ".cmd" : this.getActiveHost().getScriptExtension();
        return this.wlHome + fileSeparator + "common" + fileSeparator + "bin" + fileSeparator + "wlst" + wlstExtension;
    }

    public String getConnectUrl() {
        return this.activeHost.getAddress() + ":" + this.port;
    }

    public Host getActiveHost() {
        return this.activeHost;
    }

    public void setActiveHost(Host activeHost) {
        this.activeHost = activeHost;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getWlHome() {
        return this.wlHome;
    }

    public void setWlHome(String wlHome) {
        this.wlHome = wlHome;
    }

    public String getDomainHome() {
        return StringUtils.defaultIfEmpty((String)this.domainHome, (String)this.getDefaultDomainHome());
    }

    private String getDefaultDomainHome() {
        String fileSeparator = this.activeHost.getOperatingSystemFamily().getFileSeparator();
        return this.wlHome.substring(0, this.wlHome.lastIndexOf(fileSeparator)) + fileSeparator + "user_projects" + fileSeparator + "domains" + fileSeparator + this.name;
    }

    public void setDomainHome(String domainHome) {
        this.domainHome = domainHome;
    }

    public String getAdminServerName() {
        return this.adminServerName;
    }

    public void setAdminServerName(String adminServerName) {
        this.adminServerName = adminServerName;
    }

    public boolean isUseNodeManager() {
        return this.startMode == WlsStartMode.NodeManager;
    }

    public void setUseNodeManager(boolean useNodeManager) {
        this.startMode = WlsStartMode.NodeManager;
    }

    public WlsStartMode getStartMode() {
        return this.startMode;
    }

    public void setStartMode(WlsStartMode startMode) {
        this.startMode = startMode;
    }

    public boolean isEnableWlstShWorkaround() {
        return this.enableWlstShWorkaround;
    }

    public void setEnableWlstShWorkaround(boolean enableWlstShWorkaround) {
        this.enableWlstShWorkaround = enableWlstShWorkaround;
    }

    private List<Step> getCheckSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new WlsDomainCheckReachableStep(this));
        steps.add((Step)new CheckDirExistsStep(this.getActiveHost(), this.getWlHome()));
        steps.add(new DetectBrokenWlstStep(this));
        steps.add(new RetrieveWlsDomainStep(this));
        steps.add(new RetrieveWlsSubtypesStep(this));
        return steps;
    }

    public Map<String, String> getObjectInfo(String containmentpath) {
        WlstObjectInfoCollectingCallbackHandler handler = new WlstObjectInfoCollectingCallbackHandler();
        return this.getObjectInfoWithHandler(containmentpath, handler);
    }

    public Collection<String> getObjectInfoWithSubLevelByTypeNamesOnly(StepExecutionContext ctx, String containmentpath) {
        ArrayList<String> names = new ArrayList<String>();
        WlstDirectoryObjectInfoCollectingCallbackHandler handler = new WlstDirectoryObjectInfoCollectingCallbackHandler();
        Map<String, String> objectInfo = this.getObjectInfoWithHandler(containmentpath, handler);
        for (String key : objectInfo.keySet()) {
            String name = objectInfo.get(key);
            names.add(name);
        }
        return names;
    }

    public Map<String, String> getDirectoryObjectInfo(String containmentpath) {
        WlstDirectoryObjectInfoCollectingCallbackHandler handler = new WlstDirectoryObjectInfoCollectingCallbackHandler();
        return this.getObjectInfoWithHandler(containmentpath, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getObjectInfoWithHandler(String containmentpath, WlstObjectInfoCollectingCallbackHandlerBase handler) {
        HostSession s = this.connectToAdminHost();
        try {
            String scriptResourcePath = GET_OBJECT_BY_CONTAINMENT_PATH_SCRIPT;
            String scriptPath = s.copyToTemporaryFile((Resource)new ClassPathResource(scriptResourcePath)).getPath();
            int res = this.executeWlstJythonScript(handler, s, scriptPath, this.getUsername(), this.getPassword(), this.getConnectUrl(), containmentpath);
            if (res != 0) {
                Map<String, String> map = null;
                return map;
            }
            Map<String, String> map = handler.getObjectInfo();
            return map;
        }
        finally {
            s.close();
        }
    }

    public WlsDomain discoverChildrenInfo(Map<String, Object> discoveredAdditionalInfo, ChangePlan cp) {
        ArrayList<WlsServer> discoveredServers = new ArrayList<WlsServer>();
        if (discoveredAdditionalInfo.containsKey(WLS_SERVER_KEY)) {
            for (String serverName : (Collection)discoveredAdditionalInfo.get(WLS_SERVER_KEY)) {
                if (serverName.equals(this.getAdminServerName())) continue;
                WlsServer wlsServer = new WlsServer();
                wlsServer.setDomain(this);
                wlsServer.setHost(this.getActiveHost());
                wlsServer.setName(serverName);
                wlsServer.setLabel("Server " + serverName + " on " + this.getName());
                wlsServer = wlsServer.discover(discoveredAdditionalInfo, cp);
                discoveredServers.add(wlsServer);
            }
        }
        discoveredAdditionalInfo.put("1_com.xebialabs.deployit.plugin.wls.ci.WlsServer", discoveredServers);
        ArrayList<WlsCluster> discoveredClusters = new ArrayList<WlsCluster>();
        if (discoveredAdditionalInfo.containsKey(WLS_CLUSTER_KEY)) {
            for (String clusterName : (Collection)discoveredAdditionalInfo.get(WLS_CLUSTER_KEY)) {
                WlsCluster wlsCluster = new WlsCluster();
                wlsCluster.setDomain(this);
                wlsCluster.setName(clusterName);
                wlsCluster.setLabel("Cluster " + clusterName + " on " + this.getName());
                wlsCluster.setServers(this.getServersForCluster(discoveredAdditionalInfo, cp, wlsCluster, discoveredServers));
                wlsCluster = wlsCluster.discover(discoveredAdditionalInfo, cp);
                discoveredClusters.add(wlsCluster);
            }
        }
        discoveredAdditionalInfo.put("2_com.xebialabs.deployit.plugin.wls.ci.WlsCluster", discoveredClusters);
        return this;
    }

    private Set<WlsServer> getServersForCluster(Map<String, Object> discoveredAdditionalInfo, ChangePlan cp, WlsCluster wlsCluster, List<WlsServer> discoveredServers) {
        HashSet<WlsServer> serversOnCluster = new HashSet<WlsServer>();
        for (WlsServer server : discoveredServers) {
            cp.addSteps(Collections.singletonList(new CheckWlsServerIsOnCluster(wlsCluster, server)));
            cp.execute(discoveredAdditionalInfo);
            if (discoveredAdditionalInfo.get((Object)((Object)server) + "_ON_" + (Object)((Object)wlsCluster)) != "IS_ON_CLUSTER") continue;
            serversOnCluster.add(server);
        }
        return serversOnCluster;
    }

    public WlsDomain discover(Map<String, Object> info, ChangePlan cp) {
        cp.addSteps(this.getCheckSteps());
        cp.execute(info);
        return this;
    }

    public boolean isRunningVersion8() {
        return this.wlsVersion == WlsVersion.WEBLOGIC_8;
    }

    public WlsVersion getWlsVersion() {
        return this.wlsVersion;
    }

    public void setWlsVersion(WlsVersion wlsVersion) {
        this.wlsVersion = wlsVersion;
    }

    public boolean isRunningVersionGreaterThan9() {
        return this.wlsVersion != WlsVersion.WEBLOGIC_8;
    }
}

