/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServerConfigurationModification;
import com.xebialabs.deployit.plugin.wls.step.ActivatePendingChangesStep;
import com.xebialabs.deployit.plugin.wls.step.ModifyWlsServerStep;
import com.xebialabs.deployit.plugin.wls.step.RetrieveWlsServerStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsServerStep;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyWlsServerConfigurationModificationStep
extends WlsStepBase {
    private WlsServer server;
    private WlsServerConfigurationModification modificationToApply;
    private WlsServerConfigurationModification modificationToUnapply;
    private static Logger logger = LoggerFactory.getLogger(ApplyWlsServerConfigurationModificationStep.class);

    public ApplyWlsServerConfigurationModificationStep(WlsServer server, WlsServerConfigurationModification modificationToApply, WlsServerConfigurationModification modificationToUnapply) {
        super(server.getDomain());
        this.server = server;
        this.modificationToApply = modificationToApply;
        this.modificationToUnapply = modificationToUnapply;
        StringBuilder desc = new StringBuilder();
        if (modificationToApply != null) {
            if (modificationToUnapply != null) {
                desc.append("Remove \"" + modificationToUnapply.getClasspathAddition() + "\" and add \"" + modificationToApply.getClasspathAddition() + "\" to classpath of " + (Object)((Object)server));
            } else {
                desc.append("Add \"" + modificationToApply.getClasspathAddition() + "\" to classpath of " + (Object)((Object)server));
            }
        } else if (modificationToUnapply != null) {
            desc.append("Remove \"" + modificationToUnapply.getClasspathAddition() + "\" fron classpath of " + (Object)((Object)server));
        } else {
            throw new IllegalArgumentException("Either modificationToApply or modificationToUnapply should be non-null");
        }
        this.setDescription(desc.toString());
    }

    public boolean execute(StepExecutionContext ctx) {
        boolean couldRetrieveServerConfiguration = new RetrieveWlsServerStep(this.server).execute(ctx);
        if (!couldRetrieveServerConfiguration) {
            ctx.logError("Cannot retrieve configuration of server " + (Object)((Object)this.server));
            return false;
        }
        ctx.logOutput("********");
        String originalClasspath = this.server.getClasspath();
        logger.debug("Original classpath: {}", (Object)originalClasspath);
        String pathSeparator = this.server.getDomain().getActiveHost().getOperatingSystemFamily().getPathSeparator();
        ArrayList classpathComponents = Lists.newArrayList((Object[])StringUtils.split((String)originalClasspath, (String)pathSeparator));
        logger.debug("Original classpath components: {}", (Object)classpathComponents);
        boolean classpathWasModified = false;
        if (this.modificationToUnapply != null) {
            ArrayList classpathComponentsToRemove = Lists.newArrayList((Object[])StringUtils.split((String)this.modificationToUnapply.getClasspathAddition(), (String)pathSeparator));
            logger.debug("Classpath components to remove: {}", (Object)classpathComponentsToRemove);
            for (String c : classpathComponentsToRemove) {
                if (!classpathComponents.contains(c)) continue;
                classpathComponents.remove(c);
                classpathWasModified = true;
            }
        }
        if (this.modificationToApply != null) {
            ArrayList classpathComponentsToAdd = Lists.newArrayList((Object[])StringUtils.split((String)this.modificationToApply.getClasspathAddition(), (String)pathSeparator));
            logger.debug("Classpath components to add: {}", (Object)classpathComponentsToAdd);
            for (String c : classpathComponentsToAdd) {
                if (classpathComponents.contains(c)) continue;
                classpathComponents.add(c);
                classpathWasModified = true;
            }
        }
        logger.debug("Modified classpath components: {}", (Object)classpathComponents);
        if (!classpathWasModified) {
            ctx.logOutput("Classpath does not have to be updated. Done.");
            return true;
        }
        String modifiedClasspath = StringUtils.join((Collection)classpathComponents, (String)pathSeparator);
        logger.debug("Modified classpath: {}", (Object)modifiedClasspath);
        ctx.logOutput("Modified server classpath: " + modifiedClasspath);
        ctx.logOutput("********");
        this.server.setClasspath(modifiedClasspath);
        if (!new ModifyWlsServerStep(this.server).execute(ctx)) {
            return false;
        }
        ctx.logOutput("********");
        if (!new ActivatePendingChangesStep(this.server.getDomain()).execute(ctx)) {
            return false;
        }
        ctx.logOutput("********");
        if (!new StopWlsServerStep(this.server).execute(ctx)) {
            return false;
        }
        ctx.logOutput("********");
        if (!new StartWlsServerStep(this.server).execute(ctx)) {
            return false;
        }
        ctx.logOutput("********");
        return true;
    }

    public WlsServerConfigurationModification getModificationToApply() {
        return this.modificationToApply;
    }

    public WlsServerConfigurationModification getModificationToUnapply() {
        return this.modificationToUnapply;
    }
}

