/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.WarMapping;
/**
 * A mapping of a WAR to WebLogic middleware.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A mapping of a WAR to WebLogic middleware")
public class WlsWarMapping extends WarMapping<WlsTarget> implements WlsArtifactMapping {

	@ConfigurationItemProperty(category = "Weblogic", required = false)
	private WlsDeploymentStrategy deploymentStrategy = WlsDeploymentStrategy.CLASSIC;

	@ConfigurationItemProperty(category = "Weblogic", description = "Deployment staging mode (default is stage")
	private WlsStageMode stageMode;

	@ConfigurationItemProperty(category = "Weblogic", description = "Remote directory where the archives (ear, jar, war) are copied before deploying")
	protected String stagingDirectory;

	@ConfigurationItemProperty(category = "Weblogic")
	private WlsDeploymentPlan deploymentPlan;

	@ConfigurationItemProperty(category = "Weblogic")
	protected String deploymentPlanStagingDirectory;

	@ConfigurationItemProperty(category = "Weblogic")
	protected boolean versionnedArtifact = false;

	@ConfigurationItemProperty(category = "Weblogic")
	protected String version;

	@ConfigurationItemProperty(category = "Weblogic", description = "Time (in seconds) Deployit waits before retiring an application that has been replaced with a newer version, default is -1")
	protected int retireTimeout = -1;

	@ConfigurationItemProperty(category = "Weblogic", description = "By default, new applications and modules are configured with a Deployment Order value of 100")
	protected int deploymentOrder = 100;


	public WlsWarMapping() {
		super();
	}

	public WlsWarMapping(War source, WlsTarget target, String virtualHost, String contextRoot) {
		super(source, target, virtualHost, contextRoot);
	}

	public WlsWarMapping(War source, WlsTarget target, String virtualHost, String contextRoot, WlsStageMode stageMode, String stagingDirectory) {
		super(source, target, virtualHost, contextRoot);
		this.stageMode = stageMode;
		this.stagingDirectory = stagingDirectory;
	}


	public WlsDeploymentStrategy getDeploymentStrategy() {
		return deploymentStrategy;
	}

	public void setDeploymentStrategy(WlsDeploymentStrategy strategy) {
		this.deploymentStrategy = strategy;
	}

	public String getVersion() {
		return version;
	}

	public boolean isVersionnedArtifact() {
		return versionnedArtifact;
	}

	public WlsStageMode getStageMode() {
		return (stageMode == null ? WlsStageMode.Stage : stageMode);
	}

	public void setStageMode(WlsStageMode stageMode) {
		this.stageMode = stageMode;
	}

	public String getStagingDirectory() {
		return stagingDirectory;
	}

	public void setStagingDirectory(String stagingDirectory) {
		this.stagingDirectory = stagingDirectory;
	}

	public WlsDeploymentPlan getDeploymentPlan() {
		return deploymentPlan;
	}

	public String getDeploymentPlanStagingDirectory() {
		return deploymentPlanStagingDirectory;
	}

	public int getRetireTimeout() {
		return retireTimeout;
	}

	public void setRetireTimeout(int retireTimeout) {
		this.retireTimeout = retireTimeout;
	}

	public int getDeploymentOrder() {
		return deploymentOrder;
	}

	public void setDeploymentOrder(int deploymentOrder) {
		this.deploymentOrder = deploymentOrder;
	}
}

