/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.CmdLineArgument;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;

/**
 * Generic Step used to execute WLST commands on a {@link WlsDomain}. Can be subclassed.
 */
@SuppressWarnings("serial")
public class SimpleWlstExecutingStep extends WlsStepBase {

	/**
	 * The path of Jython script containing WLST commands.
	 */
	protected String scriptResourcePath;

	/**
	 * Arguments passed to Jython script.
	 */
	protected List<CmdLineArgument> scriptArgs;

	/**
	 * Creates a <tt>SimpleWlstExecutionStep</tt> with the specified parameters.
	 * 
	 * @param description
	 *            the description of the step
	 * @param domain
	 *            the domain on which to run this step
	 * @param scriptResourcePath
	 *            the resource path of the WLST script to execute
	 * @param scriptArgs
	 *            the parameters for the script. Automatically the username, password and the connect URL for the
	 */
	public SimpleWlstExecutingStep(String description, WlsDomain domain, String scriptResourcePath, List<CmdLineArgument> scriptArgs) {
		super(domain);
		setDescription(description);

		this.scriptResourcePath = scriptResourcePath;
		this.scriptArgs = scriptArgs;
	}

	public boolean execute(StepExecutionContext ctx) {
        CmdLine cmdLine = new CmdLine().addArgument(domain.getUsername()).addPassword(domain.getPassword()).addArgument(domain.getConnectUrl());
        for (CmdLineArgument scriptArg : scriptArgs) {
            cmdLine.add(scriptArg);
        }
		return executeWlstJythonScriptResource(ctx, scriptResourcePath, cmdLine) == 0;
	}

    protected static List<CmdLineArgument> asArguments(String... args) {
        List<CmdLineArgument> arguments = newArrayList();
        for (String arg : args) {
            arguments.add(CmdLineArgument.arg(arg));
        }

        return arguments;
    }

}
