#
# Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys

#convert a list of args into key value pair. A key is followed by its value in the list.
def asDict(lst):
    dict={}
    for x in range(len(lst)):
        if x % 2 ==0:
            dict[lst[x]]=lst[x+1]
    return dict

print "intput parameters ", sys.argv

scriptname = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)
target = sys.argv.pop(0)
appname = sys.argv.pop(0)
appPath = sys.argv.pop(0)

options = asDict(sys.argv)
options['block']='true'

print "Connecting to WebLogic"
connect(user, password, url)
edit()
startEdit()

print "Deploying application ", appname, " with the following options ", options
progress = deploy(appname, appPath, target, **options)

print "---"
progress.printStatus()
print "---"

if progress.isFailed():
	raise Exception("Failed to deploying application %s with the following options %s" % (appname, options))

progress=deploy(appname, appPath, target, **options)
print "---"
progress.printStatus()
print "---"

if progress.isFailed():
	raise

print "Saving configuration"
save()
disconnect('true')
exit('y')
