/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.ci;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wls.ci.WlsClusterResource;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;
import java.util.Set;

@ConfigurationItem(description="A WebLogic JMS Queue")
public class WlsJmsDistributedQueue
extends BaseConfigurationItem
implements WlsClusterResource {
    @ConfigurationItemProperty(description="The name of the distributed queue", required=true, identifying=true)
    private String name;
    @ConfigurationItemProperty(required=true)
    private String jndiName;
    @ConfigurationItemProperty
    private LoadBalancingPolicy loadBalancingPolicy;
    @ConfigurationItemProperty(description="Defaults to -1")
    private int forwardDelay = -1;
    @ConfigurationItemProperty
    private Set<WlsJmsQueue> members = Sets.newHashSet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public LoadBalancingPolicy getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public void setLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
        this.loadBalancingPolicy = loadBalancingPolicy;
    }

    public int getForwardDelay() {
        return this.forwardDelay;
    }

    public void setForwardDelay(int forwardDelay) {
        this.forwardDelay = forwardDelay;
    }

    public Set<WlsJmsQueue> getMembers() {
        return this.members;
    }

    public void addMember(WlsJmsQueue member) {
        this.members.add(member);
    }

    public void setMembers(Set<WlsJmsQueue> members) {
        this.members = members;
    }

    public static enum LoadBalancingPolicy {
        ROUND_ROBIN("Round-Robin"),
        RANDOM("Random");

        private final String value;

        private LoadBalancingPolicy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

