/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import com.xebialabs.deployit.ci.artifact.mapping.DeployableArtifactMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsArtifactMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDeploymentPlan;
import com.xebialabs.deployit.plugin.wls.ci.WlsDeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibrary;
import com.xebialabs.deployit.plugin.wls.ci.WlsStageMode;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import java.io.Serializable;

@ConfigurationItem(description="A mapping of a weblogic shared library to WebLogic middleware")
public class WlsSharedLibraryMapping
extends DeployableArtifactMapping<WlsSharedLibrary, WlsTarget>
implements WlsArtifactMapping {
    @ConfigurationItemProperty(required=false)
    private WlsDeploymentStrategy deploymentStrategy = WlsDeploymentStrategy.CLASSIC;
    @ConfigurationItemProperty(required=false, description="Deployment staging mode (default is stage")
    private WlsStageMode stageMode;
    @ConfigurationItemProperty(required=false, description="Remote directory where the archives (ear, jar, war) are copied before deploying")
    protected String stagingDirectory;
    @ConfigurationItemProperty
    protected boolean versionnedArtifact = false;
    @ConfigurationItemProperty
    protected String version;

    public WlsSharedLibraryMapping() {
    }

    public WlsSharedLibraryMapping(WlsSharedLibrary source, WlsCluster target) {
        super((DeployableArtifact)source, (Serializable)((Object)target));
    }

    public WlsSharedLibraryMapping(WlsSharedLibrary source, WlsCluster target, WlsStageMode stageMode, String stagingDirectory) {
        super((DeployableArtifact)source, (Serializable)((Object)target));
        this.stageMode = stageMode;
        this.stagingDirectory = stagingDirectory;
    }

    @Override
    public WlsDeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    @Override
    public void setDeploymentStrategy(WlsDeploymentStrategy deploymentStrategy) {
        this.deploymentStrategy = deploymentStrategy;
    }

    @Override
    public WlsStageMode getStageMode() {
        return this.stageMode == null ? WlsStageMode.Stage : this.stageMode;
    }

    public void setStageMode(WlsStageMode stageMode) {
        this.stageMode = stageMode;
    }

    @Override
    public String getStagingDirectory() {
        return this.stagingDirectory;
    }

    @Override
    public WlsDeploymentPlan getDeploymentPlan() {
        return null;
    }

    @Override
    public String getDeploymentPlanStagingDirectory() {
        return null;
    }

    public void setStagingDirectory(String stagingDirectory) {
        this.stagingDirectory = stagingDirectory;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isVersionnedArtifact() {
        return this.versionnedArtifact;
    }

    @Override
    public int getRetireTimeout() {
        return -1;
    }

    @Override
    public int getDeploymentOrder() {
        return 100;
    }
}

