/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.mapper;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.mapping.DeployableArtifactMapping;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsArtifactMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibrary;
import com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibraryJar;
import com.xebialabs.deployit.plugin.wls.ci.WlsStageMode;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.ModifyDeploymentOrderStep;
import com.xebialabs.deployit.plugin.wls.step.StartApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.StopApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.WaitingStep;
import com.xebialabs.deployit.plugin.wls.step.Wls8DeployArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.Wls8DeployNoStageArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.Wls8UndeployArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDeployArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDeployNoStageArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsUndeployArtifactStep;
import com.xebialabs.deployit.steps.CopyStep;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class WlsArtifactMapper<S extends NamedDeployableArtifact, M extends DeployableArtifactMapping<? super S, ? super T>, T extends WlsTarget>
extends StepGeneratingMapper<S, M, T> {
    protected List<Step> stageSteps = Lists.newArrayList();
    protected List<Step> noStageSteps = Lists.newArrayList();
    protected List<Step> startSteps = Lists.newArrayList();
    protected Set<CopyStep> copySteps = Sets.newHashSet();
    protected List<Step> retirementSteps = Lists.newArrayList();
    protected final String defaultOldVersion;
    protected final String defaultNewVersion;
    private long retirementTimeout = -1L;
    private final Ordering<M> byDeploymentOrder = new Ordering<M>(){

        public int compare(M m1, M m2) {
            WlsArtifactMapping am1 = (WlsArtifactMapping)m1;
            WlsArtifactMapping am2 = (WlsArtifactMapping)m2;
            return am1.getDeploymentOrder() - am2.getDeploymentOrder();
        }
    };

    public WlsArtifactMapper(Change<Deployment> change) {
        super(change);
        this.defaultOldVersion = this.fetchDefaultVersion((Deployment)change.getOldRevision());
        this.defaultNewVersion = this.fetchDefaultVersion((Deployment)change.getNewRevision());
        Collections.sort(this.addedMappings, this.byDeploymentOrder);
        Collections.sort(this.deletedMappings, this.byDeploymentOrder.reverse());
    }

    private String fetchDefaultVersion(Deployment deployment) {
        if (deployment == null) {
            return null;
        }
        DeploymentPackage aPackage = deployment.getSource();
        if (aPackage.getApplication() == null) {
            return "v-" + aPackage.getVersion();
        }
        String version = aPackage.getApplication().getLabel() + "-" + aPackage.getVersion();
        version = version.replace("Applications/", "");
        version = version.replace("/", "");
        return version;
    }

    protected void generateAdditionStepsForAddedMapping(S newMappingSource, M newMapping, T newMappingTarget, List<Step> steps) {
        WlsArtifactMapping mapping = (WlsArtifactMapping)newMapping;
        if (!this.isNoStageMode(mapping)) {
            this.stageSteps.addAll(this.generateStageModeDeploysSteps(mapping));
        } else {
            this.noStageSteps.addAll(this.generateNoStageModeDeploysSteps(mapping, this.copySteps));
        }
        this.startSteps.addAll(this.generateStartStep(mapping));
    }

    protected void generateDeletionStepsForDeletedMapping(S oldMappingSource, M oldVersionOfModifiedMapping, T oldMappingTarget, List<Step> steps) {
        WlsArtifactMapping mapping = (WlsArtifactMapping)oldVersionOfModifiedMapping;
        WlsTarget target = mapping.getTarget();
        NamedDeployableArtifact artifact = mapping.getSource();
        if (target.isRunningVersion8()) {
            steps.add(new Wls8UndeployArtifactStep(target, artifact));
            return;
        }
        String appVersion = this.getAppVersion(mapping, this.defaultOldVersion);
        switch (mapping.getDeploymentStrategy()) {
            case CLASSIC: {
                if (mapping.isVersionnedArtifact()) {
                    steps.add(new StopApplicationStep(target, artifact, appVersion));
                    steps.add(new WlsUndeployArtifactStep(target, artifact, appVersion));
                    break;
                }
                steps.add(new StopApplicationStep(target, artifact));
                steps.add(new WlsUndeployArtifactStep(target, artifact));
                break;
            }
            case STOP_START: {
                if (mapping.isVersionnedArtifact()) {
                    steps.add(new WlsUndeployArtifactStep(target, artifact, appVersion));
                    break;
                }
                steps.add(new WlsUndeployArtifactStep(target, artifact));
                break;
            }
            case SIDE_BY_SIDE: {
                this.retirementSteps.add(new StopApplicationStep(target, artifact, appVersion));
                this.retirementSteps.add(new WlsUndeployArtifactStep(target, artifact, appVersion));
            }
        }
    }

    private String getAppVersion(WlsArtifactMapping mapping, String defaultVersion) {
        if (!mapping.isVersionnedArtifact()) {
            return null;
        }
        if (StringUtils.isBlank((String)mapping.getVersion())) {
            return defaultVersion;
        }
        return mapping.getVersion();
    }

    public void generateUndeploySteps(List<Step> steps) {
        this.generateDeletionSteps(steps);
    }

    public void generateDeploySteps(List<Step> steps) {
        this.generateAdditionSteps(steps);
        steps.addAll(this.stageSteps);
        steps.addAll(this.copySteps);
        steps.addAll(this.noStageSteps);
    }

    public void generateStartSteps(List<Step> steps) {
        steps.addAll(this.startSteps);
    }

    public void generateRetimentSteps(List<Step> steps) {
        if (this.retirementTimeout > 0L && !this.retirementSteps.isEmpty()) {
            steps.add(new WaitingStep(this.retirementTimeout));
        }
        steps.addAll(this.retirementSteps);
    }

    private Collection<? extends Step> generateStartStep(WlsArtifactMapping mapping) {
        ArrayList steps = Lists.newArrayList();
        WlsTarget target = mapping.getTarget();
        if (target.isRunningVersion8()) {
            return Collections.emptyList();
        }
        switch (mapping.getDeploymentStrategy()) {
            case CLASSIC: 
            case SIDE_BY_SIDE: {
                if (mapping.isVersionnedArtifact()) {
                    steps.add(new StartApplicationStep(target, mapping.getSource(), this.getAppVersion(mapping, this.defaultNewVersion)));
                    break;
                }
                steps.add(new StartApplicationStep(target, mapping.getSource()));
                break;
            }
        }
        return steps;
    }

    private List<? extends Step> generateNoStageModeDeploysSteps(WlsArtifactMapping m, Set<CopyStep> copySteps) {
        ArrayList steps = Lists.newArrayList();
        Map propertyMap = KeyValuePair.toMap(m.getKeyValuePairs());
        PlaceholderFormat placeholderFormat = m.getPlaceholderFormat();
        WlsTarget target = m.getTarget();
        String remoteDestination = "";
        String remoteDeploymentPlanDestination = "";
        for (Host remoteHost : this.findHosts(target)) {
            String separator = remoteHost.getFileSeparator();
            if (StringUtils.isBlank((String)m.getStagingDirectory())) {
                throw new IllegalArgumentException("With noStage Mode, a staging directory must be filled.");
            }
            remoteDestination = m.getStagingDirectory() + separator + m.getSource().getName() + "." + this.getExtension(m.getSource());
            CopyStep copyStepArtifact = new CopyStep(Host.getLocalHost(), m.getSource().getLocation(), remoteHost, remoteDestination, propertyMap, placeholderFormat);
            copyStepArtifact.setCreateToplevelDirectory(true);
            copySteps.add(copyStepArtifact);
            if (m.getDeploymentPlan() == null) continue;
            if (StringUtils.isBlank((String)m.getDeploymentPlanStagingDirectory())) {
                throw new IllegalArgumentException("With a deployment plan, a deployment plan staging directory must be filled.");
            }
            remoteDeploymentPlanDestination = m.getDeploymentPlanStagingDirectory() + separator + m.getSource().getName() + ".xml";
            CopyStep copyStepPlan = new CopyStep(Host.getLocalHost(), m.getDeploymentPlan().getLocation(), remoteHost, remoteDeploymentPlanDestination, propertyMap, placeholderFormat);
            copyStepPlan.setCreateToplevelDirectory(true);
            copySteps.add(copyStepPlan);
        }
        if (target.isRunningVersion8()) {
            steps.add(new Wls8DeployNoStageArtifactStep(target, m.getSource(), remoteDestination));
            return steps;
        }
        WlsDeployNoStageArtifactStep step = new WlsDeployNoStageArtifactStep(target, m.getSource(), remoteDestination);
        steps.add(step);
        if (m.getDeploymentPlan() != null) {
            step.setRemoteDeploymentPlanPath(remoteDeploymentPlanDestination);
        }
        if (m.isVersionnedArtifact()) {
            throw new ResolutionException("nostage mode does not support the versioned applications");
        }
        if (m.getDeploymentOrder() != 100) {
            if (m.isVersionnedArtifact()) {
                steps.add(new ModifyDeploymentOrderStep(target, m.getSource(), this.getAppVersion(m, this.defaultNewVersion), m.getDeploymentOrder()));
            } else {
                steps.add(new ModifyDeploymentOrderStep(target, m.getSource(), m.getDeploymentOrder()));
            }
        }
        return steps;
    }

    private List<? extends Step> generateStageModeDeploysSteps(WlsArtifactMapping m) {
        ArrayList steps = Lists.newArrayList();
        Map propertyMap = KeyValuePair.toMap(m.getKeyValuePairs());
        PlaceholderFormat placeholderFormat = m.getPlaceholderFormat();
        WlsTarget target = m.getTarget();
        if (target.isRunningVersion8()) {
            steps.add(new Wls8DeployArtifactStep(target, m.getSource(), propertyMap, placeholderFormat));
            return steps;
        }
        WlsDeployArtifactStep step = new WlsDeployArtifactStep(target, m.getSource(), propertyMap, placeholderFormat);
        steps.add(step);
        if (m.getDeploymentPlan() != null) {
            Host activeHost = target.getDomain().getActiveHost();
            String remoteDeploymentPlanDestination = m.getDeploymentPlanStagingDirectory() + activeHost + m.getSource().getName() + ".xml";
            if (StringUtils.isBlank((String)m.getDeploymentPlanStagingDirectory())) {
                throw new IllegalArgumentException("With a deployment plan, a deployment plan staging directory must be filled.");
            }
            step.setDeploymentPlan(m.getDeploymentPlan(), remoteDeploymentPlanDestination);
        }
        if (m.isVersionnedArtifact()) {
            step.setAppVersion(this.getAppVersion(m, this.defaultNewVersion));
        }
        if (m.getDeploymentStrategy().equals((Object)WlsDeploymentStrategy.SIDE_BY_SIDE)) {
            if (!m.isVersionnedArtifact()) {
                throw new ResolutionException("In a Side by Side strategy mode, the version must be enabled");
            }
            if (this.isModifiedMapping(m)) {
                int artifactRetireTimeout = m.getRetireTimeout();
                step.setRetireTimeout(artifactRetireTimeout);
                if ((long)artifactRetireTimeout > this.retirementTimeout) {
                    this.retirementTimeout = artifactRetireTimeout;
                }
            }
        }
        if (m.getSource() instanceof WlsSharedLibraryJar) {
            step.setLibraryModule(true);
        }
        if (m.getDeploymentOrder() != 100) {
            if (m.isVersionnedArtifact()) {
                steps.add(new ModifyDeploymentOrderStep(target, m.getSource(), this.getAppVersion(m, this.defaultNewVersion), m.getDeploymentOrder()));
            } else {
                steps.add(new ModifyDeploymentOrderStep(target, m.getSource(), m.getDeploymentOrder()));
            }
        }
        return steps;
    }

    private boolean isModifiedMapping(final WlsArtifactMapping m) {
        return Collections2.filter((Collection)this.modifiedMappings, (Predicate)new Predicate<Pair<M, M>>(){

            public boolean apply(Pair<M, M> input) {
                return ((DeployableArtifactMapping)input.getSecond()).equals((Object)m);
            }
        }).size() > 0;
    }

    private String getExtension(NamedDeployableArtifact artifact) {
        if (artifact instanceof WlsSharedLibrary) {
            WlsSharedLibrary sharedLibrary = (WlsSharedLibrary)artifact;
            return sharedLibrary.getSharedLibraryType().toString().toLowerCase();
        }
        try {
            Field field = artifact.getClass().getField("ARCHIVE_EXTENSION");
            return "." + field.get(artifact).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected artifact " + artifact, e);
        }
    }

    private Set<Host> findHosts(WlsTarget target) {
        HashSet hosts = Sets.newHashSet();
        if (target instanceof WlsServer) {
            WlsServer server = (WlsServer)target;
            hosts.add(server.getHost());
        }
        if (target instanceof WlsCluster) {
            WlsCluster cluster = (WlsCluster)target;
            for (WlsServer server : cluster.getServers()) {
                hosts.add(server.getHost());
            }
        }
        return hosts;
    }

    private boolean isNoStageMode(WlsArtifactMapping artefactMapping) {
        WlsTarget target = artefactMapping.getTarget();
        if (target instanceof WlsCluster) {
            return artefactMapping.getStageMode().equals((Object)WlsStageMode.NoStage);
        }
        if (target instanceof WlsServer) {
            WlsServer server = (WlsServer)target;
            return server.getStageMode().equals((Object)WlsStageMode.NoStage) || artefactMapping.getStageMode().equals((Object)WlsStageMode.NoStage);
        }
        return artefactMapping.getStageMode().equals((Object)WlsStageMode.NoStage);
    }
}

