package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.mapping.DeployableArtifactMapping;

@ConfigurationItem(description = "A mapping of a weblogic shared library to WebLogic middleware")
public class WlsSharedLibraryMapping extends DeployableArtifactMapping<WlsSharedLibrary, WlsTarget> implements WlsArtifactMapping {

    @ConfigurationItemProperty(required = false)
    private WlsDeploymentStrategy deploymentStrategy = WlsDeploymentStrategy.CLASSIC;

    @ConfigurationItemProperty(required = false, description = "Deployment staging mode (default is stage")
    private WlsStageMode stageMode;

    @ConfigurationItemProperty(required = false, description = "Remote directory where the archives (ear, jar, war) are copied before deploying")
    protected String stagingDirectory;


    public WlsSharedLibraryMapping() {
    }

    public WlsSharedLibraryMapping(WlsSharedLibrary source, WlsCluster target) {
        super(source, target);
    }

    public WlsSharedLibraryMapping(WlsSharedLibrary source, WlsCluster target, WlsStageMode stageMode, String stagingDirectory) {
        super(source, target);
        this.stageMode = stageMode;
        this.stagingDirectory = stagingDirectory;
    }

    public WlsDeploymentStrategy getDeploymentStrategy() {
        return deploymentStrategy;
    }

    public void setDeploymentStrategy(WlsDeploymentStrategy deploymentStrategy) {
        this.deploymentStrategy = deploymentStrategy;
    }

    public WlsStageMode getStageMode() {
        return (stageMode == null ? WlsStageMode.Stage : stageMode);
    }

    public void setStageMode(WlsStageMode stageMode) {
        this.stageMode = stageMode;
    }

    public String getStagingDirectory() {
        return stagingDirectory;
    }

    public WlsDeploymentPlan getDeploymentPlan() {
        return null;  //There is no deployment plan for Weblogic Library files
    }

    public String getDeploymentPlanStagingDirectory() {
        return null;  //There is no stagin directory deployment plan for Weblogic Library files
    }

    public void setStagingDirectory(String stagingDirectory) {
        this.stagingDirectory = stagingDirectory;
    }
}
