/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.mapper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.plugin.wls.ci.WlsArtifactMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibrary;
import com.xebialabs.deployit.plugin.wls.ci.WlsStageMode;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.StartApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.StopApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.Wls8DeployArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.Wls8DeployNoStageArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.Wls8UndeployArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDeployArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDeployNoStageArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsUndeployArtifactStep;
import com.xebialabs.deployit.steps.CopyStep;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class WlsArtifactDeployer {
    public List<? extends Step> generateDeploySteps(List<WlsArtifactMapping> mappings) {
        ArrayList stageSteps = Lists.newArrayList();
        ArrayList noStageSteps = Lists.newArrayList();
        HashSet copySteps = Sets.newHashSet();
        for (WlsArtifactMapping mapping : mappings) {
            if (!this.isNoStageMode(mapping)) {
                stageSteps.addAll(this.generateStageModeDeploysSteps(mapping));
                continue;
            }
            noStageSteps.addAll(this.generateNoStageModeDeploysSteps(mapping, copySteps));
        }
        ArrayList allSteps = new ArrayList();
        allSteps.addAll(stageSteps);
        allSteps.addAll(copySteps);
        allSteps.addAll(noStageSteps);
        return allSteps;
    }

    private List<? extends Step> generateNoStageModeDeploysSteps(WlsArtifactMapping m, Set<CopyStep> copySteps) {
        ArrayList steps = Lists.newArrayList();
        Map propertyMap = KeyValuePair.toMap(m.getKeyValuePairs());
        PlaceholderFormat placeholderFormat = m.getPlaceholderFormat();
        WlsTarget target = m.getTarget();
        String remoteDestination = "";
        String remoteDeploymentPlanDestination = "";
        for (Host remoteHost : this.findHosts(target)) {
            String separator = remoteHost.getFileSeparator();
            if (StringUtils.isBlank((String)m.getStagingDirectory())) {
                throw new IllegalArgumentException("With noStage Mode, a staging directory must be filled.");
            }
            remoteDestination = m.getStagingDirectory() + separator + m.getSource().getName() + "." + this.getExtension(m.getSource());
            CopyStep copyStepArtifact = new CopyStep(Host.getLocalHost(), m.getSource().getLocation(), remoteHost, remoteDestination, propertyMap, placeholderFormat);
            copyStepArtifact.setCreateToplevelDirectory(true);
            copySteps.add(copyStepArtifact);
            if (m.getDeploymentPlan() == null) continue;
            if (StringUtils.isBlank((String)m.getDeploymentPlanStagingDirectory())) {
                throw new IllegalArgumentException("With a deployment plan, a deployment plan staging directory must be filled.");
            }
            remoteDeploymentPlanDestination = m.getDeploymentPlanStagingDirectory() + separator + m.getSource().getName() + ".xml";
            CopyStep copyStepPlan = new CopyStep(Host.getLocalHost(), m.getDeploymentPlan().getLocation(), remoteHost, remoteDeploymentPlanDestination, propertyMap, placeholderFormat);
            copyStepPlan.setCreateToplevelDirectory(true);
            copySteps.add(copyStepPlan);
        }
        if (target.isRunningVersion8()) {
            steps.add(new Wls8DeployNoStageArtifactStep(target, m.getSource(), remoteDestination));
        } else {
            WlsDeployNoStageArtifactStep step = new WlsDeployNoStageArtifactStep(target, m.getSource(), remoteDestination);
            if (m.getDeploymentPlan() != null) {
                step.setRemoteDeploymentPlanPath(remoteDeploymentPlanDestination);
            }
            steps.add(step);
        }
        return steps;
    }

    private List<? extends Step> generateStageModeDeploysSteps(WlsArtifactMapping m) {
        ArrayList steps = Lists.newArrayList();
        Map propertyMap = KeyValuePair.toMap(m.getKeyValuePairs());
        PlaceholderFormat placeholderFormat = m.getPlaceholderFormat();
        WlsTarget target = m.getTarget();
        if (target.isRunningVersion8()) {
            steps.add(new Wls8DeployArtifactStep(target, m.getSource(), propertyMap, placeholderFormat));
        } else {
            WlsDeployArtifactStep step = new WlsDeployArtifactStep(target, m.getSource(), propertyMap, placeholderFormat);
            if (m.getDeploymentPlan() != null) {
                Host activeHost = target.getDomain().getActiveHost();
                String remoteDeploymentPlanDestination = m.getDeploymentPlanStagingDirectory() + activeHost + m.getSource().getName() + ".xml";
                if (StringUtils.isBlank((String)m.getDeploymentPlanStagingDirectory())) {
                    throw new IllegalArgumentException("With a deployment plan, a deployment plan staging directory must be filled.");
                }
                step.setDeploymentPlan(m.getDeploymentPlan(), remoteDeploymentPlanDestination);
            }
            steps.add(step);
        }
        return steps;
    }

    private String getExtension(NamedDeployableArtifact artifact) {
        try {
            String extension = ".";
            if (artifact instanceof WlsSharedLibrary) {
                extension = extension + ((WlsSharedLibrary)artifact).getSharedLibraryType().toString().toLowerCase();
            } else {
                Field field = artifact.getClass().getField("ARCHIVE_EXTENSION");
                extension = extension + field.get(artifact).toString();
            }
            return extension;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected artifact " + artifact, e);
        }
    }

    private Set<Host> findHosts(WlsTarget target) {
        HashSet<Host> hosts = new HashSet<Host>();
        if (target instanceof WlsServer) {
            WlsServer server = (WlsServer)target;
            hosts.add(server.getHost());
        }
        if (target instanceof WlsCluster) {
            WlsCluster cluster = (WlsCluster)target;
            for (WlsServer server : cluster.getServers()) {
                hosts.add(server.getHost());
            }
        }
        return hosts;
    }

    private boolean isNoStageMode(WlsArtifactMapping artefactMapping) {
        WlsTarget target = artefactMapping.getTarget();
        if (target instanceof WlsCluster) {
            return artefactMapping.getStageMode().equals((Object)WlsStageMode.NoStage);
        }
        if (target instanceof WlsServer) {
            WlsServer server = (WlsServer)target;
            return server.getStageMode().equals((Object)WlsStageMode.NoStage) || artefactMapping.getStageMode().equals((Object)WlsStageMode.NoStage);
        }
        return artefactMapping.getStageMode().equals((Object)WlsStageMode.NoStage);
    }

    public List<? extends Step> generateUndeploysSteps(List<? extends WlsArtifactMapping> mappings) {
        ArrayList steps = Lists.newArrayList();
        for (WlsArtifactMapping wlsArtifactMapping : mappings) {
            steps.addAll(this.generateUndeploysSteps(wlsArtifactMapping));
        }
        return steps;
    }

    public List<? extends Step> generateStartSteps(List<? extends WlsArtifactMapping> mappings) {
        ArrayList steps = Lists.newArrayList();
        for (WlsArtifactMapping wlsArtifactMapping : mappings) {
            steps.addAll(this.generateStartSteps(wlsArtifactMapping));
        }
        return steps;
    }

    private List<? extends Step> generateUndeploysSteps(WlsArtifactMapping mapping) {
        ArrayList steps = Lists.newArrayList();
        WlsTarget target = mapping.getTarget();
        NamedDeployableArtifact artifact = mapping.getSource();
        switch (mapping.getDeploymentStrategy()) {
            case CLASSIC: {
                if (target.isRunningVersion8()) {
                    steps.add(new Wls8UndeployArtifactStep(target, artifact));
                    break;
                }
                steps.add(new StopApplicationStep(target, artifact));
                steps.add(new WlsUndeployArtifactStep(target, artifact));
                break;
            }
            case STOP_START: {
                if (target.isRunningVersion8()) {
                    steps.add(new Wls8UndeployArtifactStep(target, artifact));
                    break;
                }
                steps.add(new WlsUndeployArtifactStep(target, artifact));
                break;
            }
            case SIDE_BY_SIDE: {
                throw new RuntimeException("the side by side strategy is not supported yet ");
            }
        }
        return steps;
    }

    private List<? extends Step> generateStartSteps(WlsArtifactMapping mapping) {
        ArrayList steps = Lists.newArrayList();
        WlsTarget target = mapping.getTarget();
        switch (mapping.getDeploymentStrategy()) {
            case CLASSIC: {
                if (!target.isRunningVersionGreaterThan9()) break;
                steps.add(new StartApplicationStep(target, mapping.getSource()));
                break;
            }
            case STOP_START: {
                break;
            }
            case SIDE_BY_SIDE: {
                throw new RuntimeException("the side by side strategy is not supported yet ");
            }
        }
        return steps;
    }
}

