/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.LenientTemplateResolvingArchiveHostFileInputTransformer;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.Wls8WeblogicDeployerStepBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Wls8DeployArtifactStep
extends Wls8WeblogicDeployerStepBase
implements Step {
    private String extension;
    private String targetName;
    private String applicationName;
    private String applicationLocation;
    private Map<String, String> properties;
    private PlaceholderFormat placeholderFormat;

    public Wls8DeployArtifactStep(WlsTarget target, NamedDeployableArtifact artifact, Map<String, String> properties, PlaceholderFormat placeholderFormat) {
        super(target.getDomain());
        this.targetName = target.getName();
        this.applicationName = artifact.getName();
        this.extension = this.findOutExtension(artifact);
        this.applicationLocation = artifact.getLocation();
        this.properties = properties;
        this.placeholderFormat = placeholderFormat;
        if (properties == null || properties.isEmpty()) {
            this.setDescription("Deploy " + artifact + " on " + (Object)((Object)target));
        } else {
            this.setDescription("Deploy " + artifact + " on " + (Object)((Object)target) + " while replacing properties in the archive.");
        }
    }

    public Wls8DeployArtifactStep(WlsTarget target, NamedDeployableArtifact artifact) {
        this(target, artifact, Collections.emptyMap(), PlaceholderFormat.SPRING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.domain.connectToAdminHost();
        try {
            HostFile uploadedApplication = this.uploadApplication(rhs);
            String uploadedApplicationPath = uploadedApplication.getPath().replace('\\', '/');
            HashMap velocityContext = Maps.newHashMap();
            velocityContext.put("username", this.domain.getUsername());
            velocityContext.put("password", this.domain.getPassword());
            velocityContext.put("adminurl", this.domain.getConnectUrl());
            velocityContext.put("wlHome", this.domain.getWlHome());
            velocityContext.put("uploadedApplication", uploadedApplicationPath);
            velocityContext.put("target", this.targetName);
            velocityContext.put("name", this.applicationName);
            velocityContext.put("deployerAction", "-upload -stage -deploy " + uploadedApplicationPath);
            int res = this.executeWeblogicDeployerScript(ctx, rhs, velocityContext);
            boolean bl = res == 0;
            return bl;
        }
        finally {
            rhs.close();
        }
    }

    private HostFileInputStreamTransformer getTransformer() {
        if (this.properties.isEmpty()) {
            return null;
        }
        return new LenientTemplateResolvingArchiveHostFileInputTransformer(this.properties, this.placeholderFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostFile uploadApplication(HostSession rhs) {
        HostSession lhs = Host.getLocalHost().getHostSession();
        try {
            HostFile applicationFileToUpload = lhs.getFile(this.applicationLocation);
            HostFile uploadedApplicationFile = rhs.getTempFile(this.applicationName, this.extension);
            HostFileUtils.copy((HostFile)applicationFileToUpload, (HostFile)uploadedApplicationFile, (HostFileInputStreamTransformer)this.getTransformer());
            HostFile hostFile = uploadedApplicationFile;
            return hostFile;
        }
        finally {
            lhs.close();
        }
    }
}

