package com.xebialabs.deployit.plugin.wls.deployed;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.resource.JmsResourceSpec;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Base deployed type for all JMS related resources")
public class JmsResource<D extends JmsResourceSpec, C extends JmsTarget> extends PythonManagedDeployed<D, C> {

	@Property(required = true, description = "Existing or new Jms system module which will be used to hold this resource")
	private String jmsModuleName;

	@Property(required = true, description = "Global JNDI name used to look up the destination within the JNDI namespace")
	private String jndiName;

	@SuppressWarnings("unused")
	@Property(hidden = true, defaultValue = "id, name, type, properties, deployable, container, createScript, createVerb, createOrder, modifyScript, modifyVerb, modifyOrder, destroyScript, destroyVerb, destroyOrder, jndiName, jmsModuleName, subDeploymentName")
	private String standardPropertiesNotToExpose;

	private String subDeploymentName;

	@Property(hidden = true, required = false, description = "Python script invoked to create this resource")
	private String createScript;

	@Property(hidden = true, defaultValue = "Create")
	private String createVerb;

	@Property(hidden = true, defaultValue = "60")
	private int createOrder;

	@Property(hidden = true, required = false, description = "Python script invoked to upgrade this resource")
	private String modifyScript;

	@Property(hidden = true, defaultValue = "Upgrade")
	private String modifyVerb;

	@Property(hidden = true, defaultValue = "40")
	private int modifyOrder;

	@Property(hidden = true, required = false, description = "Python script invoked to destroy this resource")
	private String destroyScript;

	@Property(hidden = true, defaultValue = "Destroy")
	private String destroyVerb;

	@Property(hidden = true, defaultValue = "40")
	private int destroyOrder;

	@Create
	public void createResource(DeploymentPlanningContext result) {
		addStep(result, createOrder, createScript, createVerb);
	}

	@Modify
	public void modifyResource(DeploymentPlanningContext result) {
		if (!StringUtils.isEmpty(modifyScript)) {
			addStep(result, modifyOrder, modifyScript, modifyVerb);
		} else {
			destroyResource(result);
			createResource(result);
		}
	}

	@Destroy
	public void destroyResource(DeploymentPlanningContext result) {
		addStep(result, destroyOrder, destroyScript, destroyVerb);
	}

	public String getJmsModuleName() {
		return jmsModuleName;
	}

	public void setJmsModuleName(String jmsModuleName) {
		this.jmsModuleName = jmsModuleName;
	}

	public String getJndiName() {
		return jndiName;
	}

	public void setJndiName(String jndiName) {
		this.jndiName = jndiName;
	}

	@DerivedProperty(value = "subDeploymentName")
	public String getSubDeploymentName() {
		return subDeploymentName;
	}

	public void setSubDeploymentName(String subDeploymentName) {
		this.subDeploymentName = subDeploymentName;
	}
}
