package com.xebialabs.deployit.plugin.wls.deployed;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Base deployed of all Resources")
public class Resource<D extends Deployable> extends PythonManagedDeployed<D, WlsContainer> {

	@SuppressWarnings("unused")
	@Property(hidden = true, defaultValue = "id, name, type, properties, deployable, container, createScript, createVerb, createOrder, modifyScript, modifyVerb, modifyOrder, destroyScript, destroyVerb, destroyOrder, jndiName")
	private String standardPropertiesNotToExpose;

	@Property(hidden = true, required = false, description = "Python script invoked to create this resource")
	private String createScript;

	@Property(hidden = true, defaultValue = "Create")
	private String createVerb;

	@Property(hidden = true, defaultValue = "60")
	private int createOrder;

	@Property(hidden = true, required = false, description = "Python script invoked to upgrade this resource")
	private String modifyScript;

	@Property(hidden = true, defaultValue = "Upgrade")
	private String modifyVerb;

	@Property(hidden = true, defaultValue = "40")
	private int modifyOrder;

	@Property(hidden = true, required = false, description = "Python script invoked to destroy this resource")
	private String destroyScript;

	@Property(hidden = true, defaultValue = "Destroy")
	private String destroyVerb;

	@Property(hidden = true, defaultValue = "40")
	private int destroyOrder;

	@Create
	public void createResource(DeploymentPlanningContext result) {
		addStep(result, createOrder, createScript, createVerb);
	}

	@Modify
	public void modifyResource(DeploymentPlanningContext result) {
		if (!StringUtils.isEmpty(modifyScript)) {
			addStep(result, modifyOrder, modifyScript, modifyVerb);
		} else {
			destroyResource(result);
			createResource(result);
		}
	}

	@Destroy
	public void destroyResource(DeploymentPlanningContext result) {
		addStep(result, destroyOrder, destroyScript, destroyVerb);
	}
}
