/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereFileCopier;

public class UploadArtifactStep
implements DeploymentStep {
    private final int order;
    private final Artifact artifact;
    private final String uploadLocation;
    private final Host host;

    public UploadArtifactStep(int order, Host host, Artifact artifact, String uploadLocation) {
        this.order = order;
        this.host = host;
        this.artifact = artifact;
        this.uploadLocation = uploadLocation;
    }

    public String getDescription() {
        return String.format("Upload %s to %s on %s", this.artifact, this.uploadLocation, this.host);
    }

    public Step.Result execute(DeploymentExecutionContext ctx) throws Exception {
        OverthereConnection connection = this.host.getConnection();
        this.makeDirectories(ctx, connection);
        this.uploadArtifact(connection);
        return Step.Result.Success;
    }

    private void makeDirectories(DeploymentExecutionContext ctx, OverthereConnection connection) {
        ctx.logOutput(String.format("Create directory %s (and parent directories) on %s", this.uploadLocation, this.host));
        String parentDir = this.uploadLocation.substring(0, this.uploadLocation.lastIndexOf(connection.getHostOperatingSystem().getFileSeparator()));
        OverthereFile dir = connection.getFile(parentDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private void uploadArtifact(OverthereConnection connection) {
        OverthereFile source = this.artifact.getFile();
        OverthereFile remote = connection.getFile(this.uploadLocation);
        OverthereFileCopier.copy((OverthereFile)source, (OverthereFile)remote, null);
    }

    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UploadArtifactStep)) {
            return false;
        }
        UploadArtifactStep other = (UploadArtifactStep)obj;
        return this.artifact.equals(other.artifact) && this.host.equals((Object)other.host) && this.uploadLocation.equals(other.uploadLocation);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.artifact.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.uploadLocation.hashCode();
        return result;
    }
}

