/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import java.io.Closeable;

public class DeleteArtifactStep
implements DeploymentStep {
    private final int order;
    private final Host host;
    private final String artifactPath;

    public DeleteArtifactStep(int n, Host host, String string) {
        this.order = n;
        this.host = host;
        this.artifactPath = string;
    }

    public String getDescription() {
        return String.format("Delete artifact %s", this.artifactPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(DeploymentExecutionContext deploymentExecutionContext) throws Exception {
        OverthereConnection overthereConnection = this.host.getConnection();
        OverthereFile overthereFile = overthereConnection.getFile(this.artifactPath);
        if (overthereFile.exists()) {
            deploymentExecutionContext.logOutput("Deleting " + this.artifactPath);
            try {
                overthereFile.delete();
            }
            finally {
                Closeables.closeQuietly((Closeable)overthereConnection);
            }
            return Step.Result.Success;
        }
        deploymentExecutionContext.logOutput(String.format("Nothing exist at %s, skipping deletion", this.artifactPath));
        return Step.Result.Success;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DeleteArtifactStep)) {
            return false;
        }
        DeleteArtifactStep deleteArtifactStep = (DeleteArtifactStep)object;
        return this.host.equals((Object)deleteArtifactStep.host) && this.artifactPath.equals(deleteArtifactStep.artifactPath);
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.host.hashCode();
        n = 31 * n + this.artifactPath.hashCode();
        return n;
    }
}

