/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.ExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereProcessOutputHandler;

public class StartWlsServerWithScriptStep
implements DeploymentStep {
    private final int order;
    private final Server server;

    public StartWlsServerWithScriptStep(int n, Server server) {
        Preconditions.checkState((server.getHost() != null ? 1 : 0) != 0, (Object)"Can only start a wls.Server with a script when it its host property has been set");
        this.order = n;
        this.server = server;
    }

    public String getDescription() {
        return String.format("Start Weblogic server %s using %s", this.server, this.server.getStartCommand());
    }

    public Step.Result execute(DeploymentExecutionContext deploymentExecutionContext) throws Exception {
        CmdLine cmdLine = new CmdLine();
        for (String string : Splitter.on((String)" ").split((CharSequence)this.server.getStartCommand())) {
            cmdLine.addArgument(string);
        }
        OverthereConnection overthereConnection = this.server.getHost().getConnection();
        int n = overthereConnection.execute((OverthereProcessOutputHandler)new ExecutionContextOverthereProcessOutputHandler((ExecutionContext)deploymentExecutionContext), cmdLine);
        return n == 0 ? Step.Result.Success : Step.Result.Fail;
    }

    public int getOrder() {
        return this.order;
    }
}

