connectAndEdit()
cfPath='/JMSSystemResources/'+deployed.jmsModuleName+'/JMSResource/'+deployed.jmsModuleName+'/ConnectionFactories/'+deployed.name

createOrUpdateJmsModuleWithTarget(deployed.jmsModuleName, toWlsContainer(deployed.container).objectName)
createOrUpdateSubDeploymentWithTarget(deployed.jmsModuleName, deployed.subDeploymentName, deployed.container.objectName)

if exists(cfPath):
    print 'Modifying connection factory %s for target %s' % (deployed.name, deployed.container.name)
    setOrOverride = overrideWithWarning
else:
    print 'Creating connection factory %s for target %s' % (deployed.name, deployed.container.name)
    cd('/JMSSystemResources/'+deployed.jmsModuleName+'/JMSResource/'+deployed.jmsModuleName)
    cmo.createConnectionFactory(deployed.name)
    setOrOverride = set


cd(cfPath)
setOrOverride("JNDIName", deployed.jndiName)
setOrOverride("SubDeploymentName", deployed.subDeploymentName)

#set extra values in any at this level
propsToSet = deployed.getExposedProperties()
for key, value in propsToSet.items():
    if value is not None and isinstance(value, DictionaryObject) == False:
        print 'setting %s with value %s' % (key, value)
        setOrOverride(key, value)
        
# create all the nested objects like DeliveryFailureParams, DeliveryParamsOverrides etc..
nestedObjects = findAllNestedObjects(deployed)
if len(nestedObjects) != 0:
    print "now setting properties %s" %(nestedObjects)
    setNestedPropertiesRecursively(deployed.name, cfPath, nestedObjects, set)

saveAndExit()

#cd('/JMSSystemResources/'+jmsModuleName+'/JMSResource/'+jmsModuleName+'/ConnectionFactories/'+jmsConnectionFactoryName+'/TransactionParams/'+jmsConnectionFactoryName)
#cmo.setXAConnectionFactoryEnabled(true)
#cd('/JMSSystemResources/'+jmsModuleName+'/JMSResource/'+jmsModuleName+'/ConnectionFactories/'+jmsConnectionFactoryName+'/LoadBalancingParams/'+jmsConnectionFactoryName)
#cmo.setServerAffinityEnabled(false)
#cmo.setLoadBalancingEnabled(true)