/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.wls.DeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.StartMode;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsTargetStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsTargetStep;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LifeCycleContributor {
    @Contributor
    public void stopContainers(Deltas deltas, DeploymentPlanningContext result) {
        Set<WlsContainer> targets = this.gatherTargets(deltas.getDeltas());
        for (WlsContainer target : targets) {
            result.addStep((DeploymentStep)new StopWlsTargetStep(target.getStopOrder(), target));
        }
    }

    @Contributor
    public void startContainers(Deltas deltas, DeploymentPlanningContext result) {
        Set<WlsContainer> targets = this.gatherTargets(deltas.getDeltas());
        block5: for (WlsContainer target : targets) {
            StartMode startMode = target.getDomain().getStartMode();
            switch (startMode) {
                case NodeManager: {
                    result.addStep((DeploymentStep)new StartWlsTargetStep(target.getStartOrder(), target));
                    break;
                }
                case Script: {
                    for (Server server : target.getServers()) {
                        result.addStep((DeploymentStep)new StartWlsServerWithScriptStep(target.getStartOrder(), server));
                    }
                    continue block5;
                }
                case WindowsService: {
                    throw new RuntimeException("The Windows Service mode has not been implemented yet");
                }
            }
        }
    }

    private Set<WlsContainer> gatherTargets(List<Delta> operations) {
        HashSet<WlsContainer> wlsTargets = new HashSet<WlsContainer>();
        for (Delta operation : operations) {
            this.addTarget(wlsTargets, operation.getDeployed());
            this.addTarget(wlsTargets, operation.getPrevious());
        }
        return wlsTargets;
    }

    private void addTarget(Set<WlsContainer> wlsTargets, Deployed<?, ?> deployed) {
        ExtensibleDeployedArtifact deployedArtifact;
        DeploymentStrategy deploymentStrategy;
        if (deployed == null) {
            return;
        }
        if (deployed instanceof ExtensibleDeployedArtifact && (deploymentStrategy = (deployedArtifact = (ExtensibleDeployedArtifact)deployed).getRedeploymentStrategy()) == DeploymentStrategy.STOP_START) {
            wlsTargets.add((WlsContainer)deployed.getContainer());
        }
    }
}

