/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.deployed;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.resource.JmsResourceSpec;

@Metadata(virtual=true, description="Base deployed type for all JMS related resources")
public class JmsResource<D extends JmsResourceSpec, C extends JmsTarget>
extends PythonManagedDeployed<D, C> {
    @Property(required=true, description="Existing or new Jms system module which will be used to hold this resource")
    private String jmsModuleName;
    @Property(required=true, description="Global JNDI name used to look up the destination within the JNDI namespace")
    private String jndiName;
    @Property(hidden=true, defaultValue="id, name, type, properties, deployable, container, createScript, createVerb, createOrder, modifyScript, modifyVerb, modifyOrder, destroyScript, securityPermissions, inheritPermissions, exposeDeployedApplication, destroyVerb, destroyOrder, jndiName, jmsModuleName, subDeploymentName")
    private String standardPropertiesNotToExpose;
    @Property(required=false, description="Subdeployment name, if null the deployment name is generated by Deployit using the following pattern, ${deployed.jmsModuleName}-subdeployment-for-${deployed.name}")
    private String subDeploymentName;
    @Property(hidden=true, required=false, description="Python script invoked to create this resource")
    private String createScript;
    @Property(hidden=true, defaultValue="Create")
    private String createVerb;
    @Property(hidden=true, defaultValue="60")
    private int createOrder;
    @Property(hidden=true, required=false, description="Python script invoked to upgrade this resource")
    private String modifyScript;
    @Property(hidden=true, defaultValue="Upgrade")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="40")
    private int modifyOrder;
    @Property(hidden=true, required=false, description="Python script invoked to destroy this resource")
    private String destroyScript;
    @Property(hidden=true, defaultValue="Destroy")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="40")
    private int destroyOrder;

    @Create
    public void createResource(DeploymentPlanningContext result) {
        this.addStep(result, this.createOrder, this.createScript, this.createVerb);
    }

    @Modify
    public void modifyResource(DeploymentPlanningContext result) {
        if (!Strings.isNullOrEmpty((String)this.modifyScript)) {
            this.addStep(result, this.modifyOrder, this.modifyScript, this.modifyVerb);
        } else {
            this.destroyResource(result);
            this.createResource(result);
        }
    }

    @Destroy
    public void destroyResource(DeploymentPlanningContext result) {
        this.addStep(result, this.destroyOrder, this.destroyScript, this.destroyVerb);
    }

    public String getJmsModuleName() {
        return this.jmsModuleName;
    }

    public void setJmsModuleName(String jmsModuleName) {
        this.jmsModuleName = jmsModuleName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getSubDeploymentName() {
        return this.subDeploymentName;
    }

    public void setSubDeploymentName(String subDeploymentName) {
        this.subDeploymentName = subDeploymentName;
    }
}

