/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.container;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.container.Cluster;
import com.xebialabs.deployit.plugin.wls.container.StartMode;
import com.xebialabs.deployit.plugin.wls.container.Version;
import com.xebialabs.deployit.plugin.wls.container.WlsProtocol;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, description="WebLogic Domain which is a collection of WebLogic Server instances that is managed by a single Administration Server")
public class Domain
extends BaseContainer
implements PythonManagingContainer,
PythonManagedContainer {
    @Property(required=true, label="Host", description="The host that runs the admin server")
    private Host host;
    @Property(required=true, defaultValue="WEBLOGIC_10", label="Version", description="Version of Oracle WebLogic Server")
    private Version version;
    @Property(required=true, label="WebLogic home", description="The location of the WebLogic Server installation")
    private String wlHome;
    @Property(required=false, label="WebLogic domain home", description="The location of the WebLogic domain. Defaults to <wlHome>/../user_projects/domains/<name> (Unix) or <wlHome>\\..\\user_projects\\domains\\<name> (Windows)")
    private String domainHome;
    @Property(required=false, label="WLST path", description="Location of the wlst binary. Defaults to <wlHome>/common/bin/wlst.sh (Unix) or <wlHome>\\common\\bin\\wlst.cmd (Windows)")
    private String wlstPath;
    @Property(required=true, defaultValue="7001", label="Administrative server port", description="Port to be used by the AdminServer for this domain")
    private int port;
    @Property(defaultValue="t3", required=true, label="Administrative server protocol", description="Protocol to be used by the AdminServer for this domain")
    private WlsProtocol protocol;
    @Property(required=true, label="Administrative username", description="Username which is used to login to the WebLogic Domain.")
    private String username;
    @Property(required=true, label="Administrative password", password=true, description="Password which is used to login to the WebLogic Domain.")
    private String password;
    @Property(required=true, defaultValue="AdminServer", description="The name of the admin server")
    private String adminServerName;
    @Property(required=true, defaultValue="NodeManager", label="Start Mode", description="Tells how a managed server is start and stop, default is NodeManager, others are Script or Windows Service")
    private StartMode startMode;
    @Property(required=false, defaultValue="true", hidden=true, label="Run with daemon", description="Set to true to execute commands with the Python daemon")
    private boolean runWithDaemon;
    @Property(description="WebLogic clusters belonging to domain", asContainment=true)
    private Set<Cluster> clusters = Sets.newHashSet();

    public PythonManagingContainer getManagingContainer() {
        return this;
    }

    public CmdLine getScriptCommandLine(OverthereFile overthereFile) {
        CmdLine cmdLine = new CmdLine();
        cmdLine.addArgument(this.getWlstPath());
        cmdLine.addArgument("-i");
        cmdLine.addArgument(overthereFile.getPath());
        cmdLine.addArgument(this.getUsername());
        cmdLine.addArgument(this.getPassword());
        cmdLine.addArgument((Object)((Object)this.protocol) + "://" + this.host.getSyntheticProperty("address") + ":" + this.port);
        return cmdLine;
    }

    @Inspect
    public void inspect(InspectionPlanningContext inspectionPlanningContext) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("container", this);
        inspectionPlanningContext.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, (PythonManagingContainer)this, "wls/container/inspect-domain.py", (Map)hashMap, "Inspect " + (Object)((Object)this)));
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getWlHome() {
        return this.wlHome;
    }

    public void setWlHome(String string) {
        this.wlHome = string;
    }

    public String getDomainHome() {
        return Strings.isNullOrEmpty((String)this.domainHome) ? this.getDefaultDomainHome() : this.domainHome;
    }

    private String getDefaultDomainHome() {
        String string = this.host.getOs().getFileSeparator();
        return this.wlHome.substring(0, this.wlHome.lastIndexOf(string)) + string + "user_projects" + string + "domains" + string + this.getName();
    }

    public void setDomainHome(String string) {
        this.domainHome = string;
    }

    public String getWlstPath() {
        return Strings.isNullOrEmpty((String)this.wlstPath) ? this.getDefaultWlstPath() : this.wlstPath;
    }

    private String getDefaultWlstPath() {
        String string = this.getHost().getOs().getFileSeparator();
        String string2 = this.getHost().getOs() == OperatingSystemFamily.WINDOWS ? ".cmd" : ".sh";
        return this.wlHome + string + "common" + string + "bin" + string + "wlst" + string2;
    }

    public void setWlstPath(String string) {
        this.wlstPath = string;
    }

    public String getAdminServerName() {
        return this.adminServerName;
    }

    public void setAdminServerName(String string) {
        this.adminServerName = string;
    }

    public void setUseNodeManager(boolean bl) {
        this.startMode = StartMode.NodeManager;
    }

    public StartMode getStartMode() {
        return this.startMode;
    }

    public void setStartMode(StartMode startMode) {
        this.startMode = startMode;
    }

    public Set<Cluster> getClusters() {
        return this.clusters;
    }

    public void addClusters(Cluster cluster) {
        this.clusters.add(cluster);
    }

    public String getRuntimePath() {
        return "wls/runtime";
    }

    public boolean runWithDaemon() {
        return this.runWithDaemon;
    }

    public void setRunWithDaemon(boolean bl) {
        this.runWithDaemon = bl;
    }
}

