/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.wls.container.JmsServer;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.contributor.Predicates2;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsTargetStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsTargetStep;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployedAndCopiedArtifactLifeCycleContributor {
    static final int SHIFT_RESTART_ORDERS = 1;
    protected static final Logger logger = LoggerFactory.getLogger(DeployedAndCopiedArtifactLifeCycleContributor.class);

    @Contributor
    public void restartAfterDeployResourcesOrCopiedArtifact(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        Object object2;
        Set set = Sets.filter(this.gatherTargets(deltas.getDeltas()), (Predicate)new Predicate<Deployed<?, ?>>(){

            public boolean apply(Deployed<?, ?> deployed) {
                boolean bl = (Boolean)deployed.getProperty("restartTarget");
                return bl;
            }
        });
        logger.debug("restartable deployeds {}", (Object)set);
        HashMap hashMap = Maps.newHashMap();
        for (Object object2 : set) {
            WlsContainer wlsContainer;
            int n = (Integer)object2.getProperty("createOrder");
            if (object2.getContainer() instanceof JmsServer) {
                JmsServer jmsServer = (JmsServer)object2.getContainer();
                wlsContainer = jmsServer.getServer();
            } else {
                wlsContainer = (WlsContainer)object2.getContainer();
            }
            if (!hashMap.containsKey(wlsContainer)) {
                hashMap.put(wlsContainer, 0);
            }
            if (n <= (Integer)hashMap.get(wlsContainer)) continue;
            hashMap.put(wlsContainer, n);
        }
        Collection collection = Maps.transformEntries((Map)hashMap, (Maps.EntryTransformer)new Maps.EntryTransformer<WlsContainer, Integer, List<DeploymentStep>>(){

            public List<DeploymentStep> transformEntry(WlsContainer wlsContainer, Integer n) {
                logger.debug("create stop/start step for {} --> {} ", (Object)wlsContainer, (Object)n);
                ImmutableList.Builder builder = new ImmutableList.Builder();
                builder.add((Object)new StopWlsTargetStep(n + 1, wlsContainer));
                for (Server server : wlsContainer.getServers()) {
                    switch (server.getDomain().getStartMode()) {
                        case NodeManager: {
                            builder.add((Object)new StartWlsTargetStep(n + 1, server));
                            break;
                        }
                        case Script: {
                            builder.add((Object)new StartWlsServerWithScriptStep(n + 1, server));
                        }
                    }
                }
                return builder.build();
            }
        }).values();
        object2 = collection.iterator();
        while (object2.hasNext()) {
            List list = (List)object2.next();
            deploymentPlanningContext.addSteps((Collection)list);
        }
    }

    private Set<Deployed<?, ?>> gatherTargets(List<Delta> list) {
        logger.error("DeployedAndCopiedArtifactLifeCycleContributor.gatherTargets");
        Type type = DescriptorRegistry.getDescriptor((String)"wls.Resource").getType();
        Type type2 = DescriptorRegistry.getDescriptor((String)"wls.CopiedArtifact").getType();
        Iterable iterable = Iterables.filter(list, (Predicate)Predicates.and((Predicate)Predicates.not(Predicates2.operationIs(Operation.NOOP)), (Predicate)Predicates.or(Predicates2.deltaOf(type), Predicates2.deltaOf(type2))));
        Iterable iterable2 = Iterables.transform((Iterable)iterable, Predicates2.extractDeployed());
        HashSet hashSet = Sets.newHashSet((Iterable)iterable2);
        logger.debug("deployed {}", (Object)hashSet);
        return hashSet;
    }
}

