/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

public class Predicates2 {
    public static Predicate<Type> subtypeOf(Type type) {
        return new IsSubtypeOf(type);
    }

    public static Predicate<ConfigurationItem> instanceOf(Type type) {
        return Predicates.compose(Predicates2.subtypeOf(type), (Function)new Function<ConfigurationItem, Type>(){

            public Type apply(ConfigurationItem configurationItem) {
                return configurationItem.getType();
            }
        });
    }

    public static Predicate<Delta> deltaOf(Type type) {
        return Predicates.compose(Predicates2.instanceOf(type), Predicates2.extractDeployed());
    }

    public static Function<Delta, Deployed<?, ?>> extractDeployed() {
        return new ExtractDeployed();
    }

    public static Predicate<Delta> operationIs(Operation operation) {
        return new OperationEquals(operation);
    }

    private static class ExtractDeployed
    implements Function<Delta, Deployed<?, ?>> {
        private ExtractDeployed() {
        }

        public Deployed<?, ?> apply(Delta delta) {
            return delta.getOperation().equals((Object)Operation.DESTROY) ? delta.getPrevious() : delta.getDeployed();
        }
    }

    private static class IsSubtypeOf
    implements Predicate<Type> {
        private Type typeToMatch;

        public IsSubtypeOf(Type type) {
            this.typeToMatch = type;
        }

        public boolean apply(Type type) {
            return type.instanceOf(this.typeToMatch);
        }
    }

    private static class OperationEquals
    implements Predicate<Delta> {
        private final Operation operationToMatch;

        protected OperationEquals(Operation operation) {
            this.operationToMatch = operation;
        }

        public boolean apply(Delta delta) {
            return delta.getOperation().equals((Object)this.operationToMatch);
        }
    }
}

