/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.deployed;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;

@Metadata(virtual=true, description="Base deployed of all Resources")
public class Resource<D extends Deployable>
extends PythonManagedDeployed<D, WlsContainer> {
    @Property(hidden=true, defaultValue="id, name, type, _properties, deployable, container, createScript, createVerb, createOrder, modifyScript, modifyVerb, modifyOrder, securityPermissions, inheritPermissions, exposeDeployedApplication, destroyScript, destroyVerb, destroyOrder, jndiName, restartTarget")
    private String standardPropertiesNotToExpose;
    @Property(hidden=true, required=false, description="Python script invoked to create this resource")
    private String createScript;
    @Property(hidden=true, defaultValue="Create")
    private String createVerb;
    @Property(hidden=true, defaultValue="60")
    private int createOrder;
    @Property(hidden=true, required=false, description="Python script invoked to upgrade this resource")
    private String modifyScript;
    @Property(hidden=true, defaultValue="Upgrade")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="40")
    private int modifyOrder;
    @Property(hidden=true, required=false, description="Python script invoked to destroy this resource")
    private String destroyScript;
    @Property(hidden=true, defaultValue="Destroy")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="40")
    private int destroyOrder;
    @Property(defaultValue="false", description="trigger a restart operation (stop & start) just after the creation or the deletion of the resource")
    boolean restartTarget;

    @Create
    public void createResource(DeploymentPlanningContext deploymentPlanningContext) {
        this.addStep(deploymentPlanningContext, this.createOrder, this.createScript, this.createVerb);
    }

    @Modify
    public void modifyResource(DeploymentPlanningContext deploymentPlanningContext) {
        if (!Strings.isNullOrEmpty((String)this.modifyScript)) {
            this.addStep(deploymentPlanningContext, this.modifyOrder, this.modifyScript, this.modifyVerb);
        } else {
            this.destroyResource(deploymentPlanningContext);
            this.createResource(deploymentPlanningContext);
        }
    }

    @Destroy
    public void destroyResource(DeploymentPlanningContext deploymentPlanningContext) {
        this.addStep(deploymentPlanningContext, this.destroyOrder, this.destroyScript, this.destroyVerb);
    }
}

