/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.validator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.wls.container.Cluster;
import com.xebialabs.deployit.plugin.wls.container.JmsServer;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.AbstractQueue;
import com.xebialabs.deployit.plugin.wls.deployed.AbstractUniformDistributedQueue;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.JmsResource;
import com.xebialabs.deployit.plugin.wls.resource.JmsResourceSpec;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class PlanLevelValidator {
    @PrePlanProcessor
    public Step<?> validatePlan(DeltaSpecification deltaSpecification) {
        this.validateArtifactDeploymentOptions(deltaSpecification);
        this.validateUniqueJNDIName(deltaSpecification);
        this.validateUniformDistributedQueues(deltaSpecification);
        this.validateQueueIsTargetedToSingleJmsServer(deltaSpecification);
        return null;
    }

    private void validateArtifactDeploymentOptions(DeltaSpecification deltaSpecification) {
        Multimap<Deployable, ExtensibleDeployedArtifact<DeployableArtifact>> multimap = this.getAllDeployedArtifacts(deltaSpecification);
        for (Deployable deployable : multimap.keySet()) {
            Collection collection = multimap.get((Object)deployable);
            this.validateDeploymentOptionsAreSame(collection);
        }
    }

    private Multimap<Deployable, ExtensibleDeployedArtifact<DeployableArtifact>> getAllDeployedArtifacts(DeltaSpecification deltaSpecification) {
        HashMultimap hashMultimap = HashMultimap.create();
        for (Delta delta : deltaSpecification.getDeltas()) {
            if (delta.getOperation() != Operation.CREATE && delta.getOperation() != Operation.MODIFY || !ExtensibleDeployedArtifact.class.isAssignableFrom(delta.getDeployed().getClass())) continue;
            ExtensibleDeployedArtifact extensibleDeployedArtifact = (ExtensibleDeployedArtifact)delta.getDeployed();
            hashMultimap.put((Object)extensibleDeployedArtifact.getDeployable(), (Object)extensibleDeployedArtifact);
        }
        return hashMultimap;
    }

    private void validateDeploymentOptionsAreSame(Collection<ExtensibleDeployedArtifact<DeployableArtifact>> collection) {
        Iterator<ExtensibleDeployedArtifact<DeployableArtifact>> iterator = collection.iterator();
        if (iterator.hasNext()) {
            ExtensibleDeployedArtifact<DeployableArtifact> extensibleDeployedArtifact = iterator.next();
            while (iterator.hasNext()) {
                ExtensibleDeployedArtifact<DeployableArtifact> extensibleDeployedArtifact2 = iterator.next();
                this.validateSameValues(extensibleDeployedArtifact, extensibleDeployedArtifact2);
            }
        }
    }

    private void validateSameValues(ExtensibleDeployedArtifact<DeployableArtifact> extensibleDeployedArtifact, ExtensibleDeployedArtifact<DeployableArtifact> extensibleDeployedArtifact2) {
        if (((WlsContainer)extensibleDeployedArtifact.getContainer()).getDomain().equals((Object)((WlsContainer)extensibleDeployedArtifact2.getContainer()).getDomain())) {
            if (extensibleDeployedArtifact.isVersioned() != extensibleDeployedArtifact2.isVersioned()) {
                throw new RuntimeException("Can't have different values for 'versioned' property for same artifact " + ((DeployableArtifact)extensibleDeployedArtifact.getDeployable()).getName());
            }
            if (extensibleDeployedArtifact.getStageMode() != extensibleDeployedArtifact2.getStageMode()) {
                throw new RuntimeException("Can't have different values for 'stageMode' property for same artifact " + ((DeployableArtifact)extensibleDeployedArtifact.getDeployable()).getName());
            }
            if (extensibleDeployedArtifact.getStagingDirectory() != null && !extensibleDeployedArtifact.getStagingDirectory().equals(extensibleDeployedArtifact2.getStagingDirectory())) {
                throw new RuntimeException("Can't have different values for 'stagingDirectory' property for same artifact " + ((DeployableArtifact)extensibleDeployedArtifact.getDeployable()).getName());
            }
            if (extensibleDeployedArtifact.getRedeploymentStrategy() != extensibleDeployedArtifact2.getRedeploymentStrategy()) {
                throw new RuntimeException("Can't have different values for the deployment strategy for the same artifact " + ((DeployableArtifact)extensibleDeployedArtifact.getDeployable()).getName());
            }
        }
    }

    private void validateUniqueJNDIName(DeltaSpecification deltaSpecification) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Delta delta : deltaSpecification.getDeltas()) {
            if (delta.getOperation() != Operation.CREATE && delta.getOperation() != Operation.MODIFY || !JmsResource.class.isAssignableFrom(delta.getDeployed().getClass())) continue;
            JmsResource jmsResource = (JmsResource)delta.getDeployed();
            if (hashMap.get(jmsResource.getJndiName()) != null && !((String)hashMap.get(jmsResource.getJndiName())).equals(((JmsResourceSpec)jmsResource.getDeployable()).getName())) {
                throw new RuntimeException(String.format("Jndi name %s is in use by multiple resource sources", jmsResource.getJndiName()));
            }
            hashMap.put(jmsResource.getJndiName(), ((JmsResourceSpec)jmsResource.getDeployable()).getName());
        }
    }

    private void validateUniformDistributedQueues(DeltaSpecification deltaSpecification) {
        HashMap<String, Cluster> hashMap = new HashMap<String, Cluster>();
        for (Delta delta : deltaSpecification.getDeltas()) {
            if (delta.getOperation() != Operation.CREATE && delta.getOperation() != Operation.MODIFY || !AbstractUniformDistributedQueue.class.isAssignableFrom(delta.getDeployed().getClass())) continue;
            AbstractUniformDistributedQueue abstractUniformDistributedQueue = (AbstractUniformDistributedQueue)delta.getDeployed();
            Cluster cluster = this.getContainerCluster(abstractUniformDistributedQueue);
            if (hashMap.containsKey(abstractUniformDistributedQueue.getName()) && !((Cluster)hashMap.get(abstractUniformDistributedQueue.getName())).equals(cluster)) {
                throw new RuntimeException(String.format("The UDD %s must be targeted to servers within a single cluster or a single stand-alone server", abstractUniformDistributedQueue.getName()));
            }
            hashMap.put(abstractUniformDistributedQueue.getName(), cluster);
        }
    }

    private void validateQueueIsTargetedToSingleJmsServer(DeltaSpecification deltaSpecification) {
        HashMap<String, Container> hashMap = new HashMap<String, Container>();
        for (Delta delta : deltaSpecification.getDeltas()) {
            if (delta.getOperation() != Operation.CREATE && delta.getOperation() != Operation.MODIFY || !AbstractQueue.class.isAssignableFrom(delta.getDeployed().getClass())) continue;
            AbstractQueue abstractQueue = (AbstractQueue)delta.getDeployed();
            if (hashMap.containsKey(abstractQueue.getName()) && !((JmsServer)abstractQueue.getContainer()).equals(hashMap.get(abstractQueue.getName()))) {
                throw new RuntimeException(String.format("Queue %s must be targeted to only a single JmsServer", abstractQueue.getName()));
            }
            hashMap.put(abstractQueue.getName(), abstractQueue.getContainer());
        }
    }

    private Cluster getContainerCluster(AbstractUniformDistributedQueue abstractUniformDistributedQueue) {
        JmsTarget jmsTarget = (JmsTarget)abstractUniformDistributedQueue.getContainer();
        Cluster cluster = null;
        if (Cluster.class.isAssignableFrom(jmsTarget.getClass())) {
            cluster = (Cluster)jmsTarget;
        } else if (JmsServer.class.isAssignableFrom(jmsTarget.getClass())) {
            cluster = ((JmsServer)jmsTarget).getServer().getClusterIfAny();
        }
        return cluster;
    }
}

