/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.wls.DeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.ResourceTargetRestartPolicy;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.CopiedArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.Resource;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsTargetStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsTargetStep;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WlsContainerStopStartContributor {
    @Contributor
    public void stopContainers(Deltas deltas, DeploymentPlanningContext result) {
        for (WlsContainer target : WlsContainerStopStartContributor.gatherTargets(deltas.getDeltas())) {
            result.addSteps(target.getStopSteps(target.getStopOrder()));
        }
    }

    @Contributor
    public void startContainers(Deltas deltas, DeploymentPlanningContext result) {
        for (WlsContainer target : WlsContainerStopStartContributor.gatherTargets(deltas.getDeltas())) {
            result.addSteps(target.getStartSteps(target.getStartOrder()));
        }
    }

    private static Set<WlsContainer> gatherTargets(List<Delta> operations) {
        HashSet<WlsContainer> wlsTargets = new HashSet<WlsContainer>();
        for (Delta operation : operations) {
            WlsContainerStopStartContributor.addTarget(wlsTargets, operation.getOperation(), operation.getDeployed());
            WlsContainerStopStartContributor.addTarget(wlsTargets, operation.getOperation(), operation.getPrevious());
        }
        return wlsTargets;
    }

    private static void addTarget(Set<WlsContainer> wlsTargets, Operation operation, Deployed<?, ?> deployed) {
        ExtensibleDeployedArtifact deployedArtifact;
        DeploymentStrategy deploymentStrategy;
        if (deployed == null) {
            return;
        }
        if (operation == Operation.NOOP) {
            return;
        }
        if (deployed instanceof Resource || deployed instanceof CopiedArtifact) {
            boolean restartTarget = (Boolean)deployed.getProperty("restartTarget");
            ResourceTargetRestartPolicy restartPolicy = (ResourceTargetRestartPolicy)((Object)deployed.getProperty("targetRestartPolicy"));
            if (restartTarget && restartPolicy == ResourceTargetRestartPolicy.STOP_START) {
                wlsTargets.add((WlsContainer)deployed.getContainer());
            }
        } else if (deployed instanceof ExtensibleDeployedArtifact && (deploymentStrategy = (deployedArtifact = (ExtensibleDeployedArtifact)deployed).getRedeploymentStrategy()) == DeploymentStrategy.STOP_START) {
            wlsTargets.add((WlsContainer)deployed.getContainer());
        }
    }

    public static List<Step> startContainer(WlsContainer container, final int order) {
        switch (container.getDomain().getStartMode()) {
            case NodeManager: {
                return ImmutableList.of((Object)((Object)new StartWlsTargetStep(order, container)));
            }
            case Script: {
                return Lists.transform((List)Lists.newArrayList(container.getServers()), (Function)new Function<Server, Step>(){

                    public Step apply(Server input) {
                        return new StartWlsServerWithScriptStep(order, input);
                    }
                });
            }
            case WindowsService: {
                throw new RuntimeException("The Windows Service mode has not been implemented yet");
            }
        }
        throw new RuntimeException(String.format("Invalid startMode %s", new Object[]{container.getDomain().getStartMode()}));
    }

    public static List<Step> stopContainer(WlsContainer container, int order) {
        return ImmutableList.of((Object)((Object)new StopWlsTargetStep(order, container)));
    }
}

