/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.freemarker;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateEvaluator {
    protected static final Logger logger = LoggerFactory.getLogger(TemplateEvaluator.class);

    public static void evaluateTemplate(OverthereFile renderTo, String templatePath, Map<String, Object> vars) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        OutputStream out = renderTo.getOutputStream();
        try {
            Template template = cfg.getTemplate(templatePath);
            template.process(vars, (Writer)new OutputStreamWriter(out));
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)out);
        }
    }
}

