package com.xebialabs.deployit.plugin.wls.container;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;

import java.util.HashMap;
import java.util.Map;

import static com.google.common.base.Preconditions.checkState;

@SuppressWarnings("serial")
public class StopWlsServerWithScriptStep extends ScriptExecutionStep {

    public StopWlsServerWithScriptStep(int order, Server server) {
        super(order, server.<String>getProperty("stopScript"), server.getHost(), buildPythonVars(server), getDescription(server));
        checkState(!Strings.nullToEmpty(server.getStopCommand()).trim().isEmpty(), "stopCommand is blank for " + server);
        checkState(server.getHost() != null, "Can only stop a wls.Server with a script when its host property has been set");
    }

    private static String getDescription(Server server) {
        return String.format("Stop Weblogic server %s using a script", server);
    }

    private static Map<String, Object> buildPythonVars(Server server) {
        Map<String, Object> vars = new HashMap<String, Object>();
        vars.put("container", server);
        return vars;
    }
}
