/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.specification.jee5;

import com.crossingchannels.portal.websphere.specification.jee5.IllegalDescriptorFoundException;
import com.crossingchannels.portal.websphere.specification.jee5.dom.ApplicationType;
import com.crossingchannels.portal.websphere.specification.jee5.dom.ModuleType;
import com.crossingchannels.portal.websphere.specification.jee5.dom.ObjectFactory;
import com.crossingchannels.portal.websphere.specification.jee5.dom.WebType;
import com.crossingchannels.portal.websphere.util.ChangeNamespaceXmlFilter;
import com.crossingchannels.portal.websphere.util.UnexpectedXmlElementException;
import com.crossingchannels.portal.websphere.util.XmlUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.Validate;

public class EarDescriptor {
    private static final Set<String> COMPATIBLE_NAMESPACES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http://java.sun.com/xml/ns/javaee", "")));
    private static final String TARGET_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    private String displayName;
    private final Map<String, String> webModules = new HashMap<String, String>();

    public static final EarDescriptor fromInputStream(InputStream earXmlInputStream) throws IllegalDescriptorFoundException {
        ApplicationType domApplication;
        Validate.notNull((Object)earXmlInputStream);
        try {
            domApplication = XmlUtil.loadDom(earXmlInputStream, ObjectFactory.class.getPackage(), ApplicationType.class, new ChangeNamespaceXmlFilter(TARGET_NAMESPACE, COMPATIBLE_NAMESPACES));
        }
        catch (JAXBException e) {
            throw new IllegalDescriptorFoundException("EAR descriptor contains invalid XML", e);
        }
        catch (UnexpectedXmlElementException e) {
            throw new IllegalDescriptorFoundException("EAR descriptor contains illegal XML root element", e);
        }
        EarDescriptor earDescriptor = new EarDescriptor();
        if (!domApplication.getDisplayName().isEmpty()) {
            earDescriptor.setDisplayName(domApplication.getDisplayName().get(0).getValue());
        }
        for (ModuleType moduleType : domApplication.getModule()) {
            if (moduleType.getWeb() == null) continue;
            WebType webType = moduleType.getWeb();
            earDescriptor.addWebArchive(webType.getWebUri().getValue(), webType.getContextRoot().getValue());
        }
        return earDescriptor;
    }

    public void addWebArchive(String webArchiveURI, String contextRoot) {
        this.webModules.put(webArchiveURI, contextRoot);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getWebArchiveContextRoot(String webArchiveURI) {
        return this.webModules.get(webArchiveURI);
    }

    public Set<String> getWebArchiveURIs() {
        return Collections.unmodifiableSet(this.webModules.keySet());
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

