/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.specification.jee5;

import com.crossingchannels.portal.websphere.specification.jee5.IllegalDescriptorFoundException;
import com.crossingchannels.portal.websphere.specification.jee5.WebDescriptor;
import com.crossingchannels.portal.websphere.specification.jsr286.PortletDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import org.apache.commons.lang.Validate;

public class WebArchive {
    private final String archiveName;
    private final File archiveOnDisk;
    private WebDescriptor webDescriptor = null;
    private PortletDescriptor portletDescriptor = null;

    public static WebArchive fromDisk(String location) throws IOException {
        Validate.notNull((Object)location);
        File fileRef = new File(location);
        if (!fileRef.exists() || !fileRef.canRead()) {
            throw new FileNotFoundException(String.format("Unable to read file [%s]", location));
        }
        return new WebArchive(fileRef);
    }

    private WebArchive(File archive) throws IOException {
        this.archiveOnDisk = archive;
        this.archiveName = archive.getName();
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public WebDescriptor getDescriptor() throws IllegalDescriptorFoundException, IOException {
        if (this.webDescriptor == null) {
            this.webDescriptor = this.loadWebDescriptor();
        }
        return this.webDescriptor;
    }

    public PortletDescriptor getPortletDescriptor() throws IllegalDescriptorFoundException, IOException {
        if (this.portletDescriptor == null) {
            this.portletDescriptor = this.loadPortletDescriptor();
        }
        return this.portletDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebDescriptor loadWebDescriptor() throws IllegalDescriptorFoundException, IOException {
        JarFile warFile = new JarFile(this.archiveOnDisk);
        InputStream descriptor = warFile.getInputStream(warFile.getJarEntry("WEB-INF/web.xml"));
        try {
            WebDescriptor webDescriptor = WebDescriptor.fromInputStream(descriptor);
            return webDescriptor;
        }
        finally {
            warFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortletDescriptor loadPortletDescriptor() throws IllegalDescriptorFoundException, IOException {
        JarFile warFile = new JarFile(this.archiveOnDisk);
        InputStream descriptor = warFile.getInputStream(warFile.getJarEntry("WEB-INF/portlet.xml"));
        try {
            PortletDescriptor portletDescriptor = PortletDescriptor.fromInputStream(descriptor);
            return portletDescriptor;
        }
        finally {
            warFile.close();
        }
    }
}

