/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.deployable.DeployableXmlAccessConfigurationItem;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step.ExecuteXmlAccessConfigurationItemStep;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@Metadata(virtual=true, description="Resource deployed using XML Access")
public class DeployedXmlAccessConfigurationItem<D extends DeployableXmlAccessConfigurationItem>
extends BaseDeployed<D, WpContainer> {
    @Property(hidden=true, defaultValue="")
    private String createScript;
    @Property(hidden=true, defaultValue="", required=false)
    private String destroyScript;
    @Property(hidden=true, defaultValue="", required=false)
    private String modifyScript;
    @Property(hidden=true, defaultValue="50")
    private int createOrder;
    @Property(hidden=true, defaultValue="50", required=false)
    private int destroyOrder;
    @Property(hidden=true, defaultValue="50", required=false)
    private int modifyOrder;

    public String getCreateScript() {
        return this.createScript;
    }

    public String getDestroyScript() {
        return this.destroyScript;
    }

    public String getModifyScript() {
        return this.modifyScript;
    }

    public void setCreateScript(String installScript) {
        this.createScript = installScript;
    }

    public void setDestroyScript(String uninstallScript) {
        this.destroyScript = uninstallScript;
    }

    public void setModifyScript(String updateScript) {
        this.modifyScript = updateScript;
    }

    public int getCreateOrder() {
        return this.createOrder;
    }

    public void setCreateOrder(int createOrder) {
        this.createOrder = createOrder;
    }

    public int getDestroyOrder() {
        return this.destroyOrder;
    }

    public void setDestroyOrder(int destroyOrder) {
        this.destroyOrder = destroyOrder;
    }

    public int getModifyOrder() {
        return this.modifyOrder;
    }

    public void setModifyOrder(int modifyOrder) {
        this.modifyOrder = modifyOrder;
    }

    @Create
    public void installResource(DeploymentPlanningContext ctx) {
        if (StringUtils.isNotEmpty((String)this.createScript)) {
            ctx.addSteps(this.buildSteps(this.createScript, this.createOrder));
        }
    }

    @Modify
    public void updateResource(DeploymentPlanningContext ctx) {
        if (StringUtils.isNotEmpty((String)this.modifyScript)) {
            ctx.addSteps(this.buildSteps(this.modifyScript, this.modifyOrder));
        } else {
            this.uninstallResource(ctx);
            this.installResource(ctx);
        }
    }

    @Destroy
    public void uninstallResource(DeploymentPlanningContext ctx) {
        if (StringUtils.isNotEmpty((String)this.destroyScript)) {
            ctx.addSteps(this.buildSteps(this.destroyScript, this.destroyOrder));
        }
    }

    @ControlTask(description="Reinstall")
    public List<? extends Step> reinstall() {
        return this.buildSteps(this.createScript, this.createOrder);
    }

    protected List<Step> buildSteps(String script, int order) {
        return Collections.singletonList(new ExecuteXmlAccessConfigurationItemStep(script, order, (Deployed<? extends Deployable, ? extends WpContainer>)this));
    }
}

