package com.crossingchannels.portal.websphere.ci.base.util;

import com.xebialabs.deployit.plugin.api.reflect.Type;

/**
 * Helper methods to handle functionality provided by {@link Type}.
 * 
 * @author fwiegerinck
 * @since 1.1
 * @version 1.1
 */
public final class TypeHelper {

    /**
     * Check if the <code>baseType</code> is an instance of the provided <code>superType</code>
     * 
     * @param baseType
     *            Base type to validate.
     * @param superType
     *            Expected super type.
     * @return TRUE if the <code>baseType</code> is a subtype or the same type as <code>superType</code>, FALSE otherwise.
     */
    public static boolean isInstanceOf(final Type baseType, final Type superType) {

        // If base type is NULL, then result is always FALSE
        if (baseType == null) {
            return false;
        }
        // If super type is NULL, then result is always FALSE
        if (superType == null) {
            return false;
        }

        // Perform comparison
        return baseType.isSubTypeOf(superType) || baseType.equals(superType);
    }

    /**
     * Hide constructor for utility class.
     */
    private TypeHelper() {
        // Never called
    }

}
