package com.crossingchannels.portal.websphere.ci.policy.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFileArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.overthere.OverthereFile;

import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpRuntimeContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step.ExecuteXmlAccessConfigurationItemStep;

/**
 * Provides added artifact copy functionality before executing an XML access script
 * 
 * @author rveldwijk
 */
@SuppressWarnings("serial")
public class PolicyDeploymentStep extends ExecuteXmlAccessConfigurationItemStep {

    /**
     * Define name of context item with location of the policy file on the remote filesystem.
     */
	private static final String CONTEXTNAME_LOCATION_ON_REMOTE_FS = "locationOfPolicyOnRemoteFs";

	/**
     * Store CI used during parsing of policy file.
     */
    private final BaseDeployedArtifact<BaseDeployableFileArtifact, WpRuntimeContainer> deployedCi;  

    /**
     * Initialize a new Policy deployment step using XMLAccess.
     * 
     * @param script
     *            Path to the XML Access script to execute.
     * @param deployedCi
     *            The Deployed CI associated with the step.
     * @param order
     *            The order used to arrange the steps.
     */
	public PolicyDeploymentStep(String script, final BaseDeployedArtifact<BaseDeployableFileArtifact, WpRuntimeContainer> deployedCi, int order) {
		super(script, deployedCi, order);
		
		//Store value
		this.deployedCi = deployedCi;
	}
	
    /**
     * {@inheritDoc}
     */
	@Override
	public StepExitCode execute(ExecutionContext ctx) {
        // Get connection with target host
        final WpRuntimeContainer runtimeContainer = deployedCi.getContainer();
        final OverthereFile policyFile = runtimeContainer.getHost().getConnection().getTempFile("registerPolicy", ".xml");

        // Copy to target server
        ctx.logOutput("Copy policy file to target host");
        deployedCi.getFile().copyTo(policyFile);

    	// Add path to the context of the step and make sure it is in the right format
    	String path = policyFile.getPath().replace('\\', '/');
    	if (!path.startsWith("/")) {
			path = "/" + path;
		}
    	addToStepContext(CONTEXTNAME_LOCATION_ON_REMOTE_FS, path);
    	
    	// Execute XMLAccess
		return super.execute(ctx);
	}

}
