/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.com.crossingchannels.portal.websphere.ci.policy.contributor;

import com.crossingchannels.portal.websphere.ci.base.contributor.AbstractStepsContributor;
import com.crossingchannels.portal.websphere.ci.policy.step.PolicyDeploymentStep;
import com.crossingchannels.portal.websphere.util.XmlUtil;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFileArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpRuntimeContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step.ExecuteXmlAccessConfigurationItemStep;
import java.text.MessageFormat;
import javax.xml.xpath.XPathExpressionException;

public class PolicyStepsContributor
extends AbstractStepsContributor<BaseDeployedArtifact<BaseDeployableFileArtifact, WpRuntimeContainer>> {
    private static final Type TYPE_POLICY = Type.valueOf((String)"wp.Policy");
    private static final Type TYPE_WPRUNTIMECONTAINER = Type.valueOf((String)"wp.WpRuntimeContainer");
    private static final String PROPERTY_REGISTER = "registerScript";
    private static final String PROPERTY_UNREGISTER = "unregisterScript";
    private static final String PROPERTY_REGISTER_ORDER = "registerScriptOrder";
    private static final String PROPERTY_UNREGISTER_ORDER = "unregisterScriptOrder";
    private static final String PROPERTY_POLICY_NAME = "policyName";
    private static final String POLICYNAME_XPATH_EXPRESSION = "/policyList/policy/policyValue[@Name='PznType']/value";

    public PolicyStepsContributor() {
        super(TYPE_POLICY, TYPE_WPRUNTIMECONTAINER);
    }

    @Override
    @Contributor
    public void contributePortletSteps(Deltas deltas, DeploymentPlanningContext context) {
        super.contributePortletSteps(deltas, context);
    }

    @Override
    protected void install(BaseDeployedArtifact<BaseDeployableFileArtifact, WpRuntimeContainer> artifactToInstall, DeploymentPlanningContext context, Delta delta) {
        this.lookupPolicyName(artifactToInstall);
        context.addStep((Step)new PolicyDeploymentStep((String)artifactToInstall.getProperty(PROPERTY_REGISTER), artifactToInstall, (int)((Integer)artifactToInstall.getProperty(PROPERTY_REGISTER_ORDER))));
    }

    @Override
    protected void update(BaseDeployedArtifact<BaseDeployableFileArtifact, WpRuntimeContainer> newArtifact, BaseDeployedArtifact<BaseDeployableFileArtifact, WpRuntimeContainer> oldArtifact, DeploymentPlanningContext context, Delta delta) {
        this.install(newArtifact, context, delta);
    }

    @Override
    protected void uninstall(BaseDeployedArtifact<BaseDeployableFileArtifact, WpRuntimeContainer> artifactToUninstall, DeploymentPlanningContext context, Delta delta) {
        this.lookupPolicyName(artifactToUninstall);
        context.addStep((Step)new ExecuteXmlAccessConfigurationItemStep((String)artifactToUninstall.getProperty(PROPERTY_UNREGISTER), (Deployed<? extends Deployable, ? extends WpContainer>)artifactToUninstall, (Integer)artifactToUninstall.getProperty(PROPERTY_UNREGISTER_ORDER)));
    }

    private void lookupPolicyName(BaseDeployedArtifact<BaseDeployableFileArtifact, WpRuntimeContainer> artifact) {
        try {
            String name = XmlUtil.getValue(POLICYNAME_XPATH_EXPRESSION, artifact.getFile().getInputStream());
            artifact.setProperty(PROPERTY_POLICY_NAME, (Object)name);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(MessageFormat.format("Missing PznType in policy xml for CI {0}", artifact.getId()));
        }
    }
}

