/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed;

import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecurityLevel;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubject;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubjectType;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.AbstractAclMapping;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Metadata(description="Define ACL mapping for virtual users and groups", root=Metadata.ConfigurationItemRoot.NESTED)
public class BaseVirtualUserAndGroupsAclMapping
extends AbstractAclMapping {
    private static final PortalSecuritySubject SUBJECT_ANONYMOUS_PORTAL_USER = new PortalSecuritySubject("anonymous portal user", PortalSecuritySubjectType.USER);
    private static final PortalSecuritySubject SUBJECT_ALL_AUTHENTICATED_PORTAL_USERS = new PortalSecuritySubject("all authenticated portal users", PortalSecuritySubjectType.USER);
    private static final PortalSecuritySubject SUBJECT_ALL_PORTAL_USER_GROUPS = new PortalSecuritySubject("all portal user groups", PortalSecuritySubjectType.GROUP);
    @Property(label="Anonymous Portal User", category="Security", description="Set the security level for anonymous portal users.", required=true)
    private PortalSecurityLevel securityLevelForAnonymousPortalUser = PortalSecurityLevel.NONE;
    @Property(label="All Authenticated Portal Users", category="Security", description="Set the security level for all authenticated portal users.", required=true)
    private PortalSecurityLevel securityLevelForAllAuthenticatedPortalUsers = PortalSecurityLevel.NONE;
    @Property(label="All Portal User Groups", category="Security", description="Set the security level for all portal users groups.", required=true)
    private PortalSecurityLevel securityLevelForAllPortalUserGroups = PortalSecurityLevel.NONE;

    public PortalSecurityLevel getSecurityLevelForAnonymousPortalUser() {
        return this.securityLevelForAnonymousPortalUser;
    }

    public void setSecurityLevelForAnonymousPortalUser(PortalSecurityLevel securityLevelForAnonymousPortalUser) {
        this.securityLevelForAnonymousPortalUser = securityLevelForAnonymousPortalUser;
    }

    public PortalSecurityLevel getSecurityLevelForAllAuthenticatedPortalUsers() {
        return this.securityLevelForAllAuthenticatedPortalUsers;
    }

    public void setSecurityLevelForAllAuthenticatedPortalUsers(PortalSecurityLevel securityLevelForAllAuthenticatedPortalUsers) {
        this.securityLevelForAllAuthenticatedPortalUsers = securityLevelForAllAuthenticatedPortalUsers;
    }

    public PortalSecurityLevel getSecurityLevelForAllPortalUserGroups() {
        return this.securityLevelForAllPortalUserGroups;
    }

    public void setSecurityLevelForAllPortalUserGroups(PortalSecurityLevel securityLevelForAllPortalUserGroups) {
        this.securityLevelForAllPortalUserGroups = securityLevelForAllPortalUserGroups;
    }

    @Override
    public Map<PortalSecurityLevel, Set<PortalSecuritySubject>> getMapping() {
        HashMap<PortalSecurityLevel, Set<PortalSecuritySubject>> mapping = new HashMap<PortalSecurityLevel, Set<PortalSecuritySubject>>();
        this.addMapping(mapping, SUBJECT_ANONYMOUS_PORTAL_USER, this.securityLevelForAnonymousPortalUser);
        this.addMapping(mapping, SUBJECT_ALL_AUTHENTICATED_PORTAL_USERS, this.securityLevelForAllAuthenticatedPortalUsers);
        this.addMapping(mapping, SUBJECT_ALL_PORTAL_USER_GROUPS, this.securityLevelForAllPortalUserGroups);
        return mapping;
    }

    private void addMapping(Map<PortalSecurityLevel, Set<PortalSecuritySubject>> mapping, PortalSecuritySubject subject, PortalSecurityLevel securityLevel) {
        Set<Object> portalSecuritySubjects;
        if (mapping.containsKey((Object)securityLevel)) {
            portalSecuritySubjects = mapping.get((Object)securityLevel);
        } else {
            portalSecuritySubjects = new HashSet();
            mapping.put(securityLevel, portalSecuritySubjects);
        }
        portalSecuritySubjects.add(subject);
    }
}

