package com.crossingchannels.portal.websphere.executor;

import org.apache.commons.lang.Validate;

import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;


/**
 * Factory to create different executors for each of the environments.
 * 
 * @author fwiegerinck
 */
public class ExecutorFactory {

    /**
     * Define instance of factory
     */
    public static final ExecutorFactory INSTANCE = new ExecutorFactory();

    /**
     * Create an instance of the XmlAccessExecutor for the specified target
     * 
     * @param target
     *            Target container used to executed XmlAccess command. Value cannot be NULL
     * @return Instance of the XmlAccessExecutor
     */
    public XmlAccessExecutor createXmlAccessExecutor(final WpContainer target) {

        // Preconditions
        Validate.notNull(target);

        // Initialize executor
        return new XmlAccessExecutor(target);
    }

}
