/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.ci.base.contributor;

import com.crossingchannels.portal.websphere.ci.base.util.CastHelper;
import com.crossingchannels.portal.websphere.ci.base.util.TypeHelper;
import com.crossingchannels.portal.websphere.util.InternalPluginException;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.lang.reflect.ParameterizedType;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStepsContributor<D extends Deployed<?, ?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStepsContributor.class);
    private final Type targetCiType;
    private final Type targetContainerType;
    private final Class<D> baseJavaType;

    protected AbstractStepsContributor(Type targetCiType, Type targetContainerType) {
        java.lang.reflect.Type type;
        Validate.notNull((Object)targetCiType);
        Validate.notNull((Object)targetContainerType);
        this.targetCiType = targetCiType;
        this.targetContainerType = targetContainerType;
        this.baseJavaType = this.getClass().getGenericSuperclass() instanceof ParameterizedType ? ((type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]) instanceof Class ? (Class)CastHelper.cast(type) : (Class)CastHelper.cast(((ParameterizedType)type).getRawType())) : (Class)CastHelper.cast(Deployed.class);
    }

    @Contributor
    public void contributePortletSteps(Deltas deltas, DeploymentPlanningContext context) {
        block6: for (Delta delta : deltas.getDeltas()) {
            switch (delta.getOperation()) {
                case CREATE: {
                    this.processInstallationOfCi(delta, context);
                    continue block6;
                }
                case MODIFY: {
                    this.processUpdateOfCi(delta, context);
                    continue block6;
                }
                case DESTROY: {
                    this.processUninstallationOfCi(delta, context);
                    continue block6;
                }
                case NOOP: {
                    continue block6;
                }
            }
            throw new IllegalStateException("Unknown delta operation: " + delta.getOperation());
        }
    }

    protected void processInstallationOfCi(Delta delta, DeploymentPlanningContext context) {
        Validate.notNull((Object)delta);
        Validate.notNull((Object)context);
        Deployed rawDeployedCi = delta.getDeployed();
        LOGGER.trace("Called to handle install request for CI with id [{}]", (Object)rawDeployedCi.getId());
        if (!this.matchesCiTypeCriteria(rawDeployedCi)) {
            LOGGER.trace("CI [{}] doesn't match criteria, skip it...", (Object)rawDeployedCi.getId());
            return;
        }
        if (!this.baseJavaType.isInstance(rawDeployedCi)) {
            LOGGER.error("Unable to process CI [{}]. CI class [{}] doesn't match required (generics) type [{}]", new Object[]{rawDeployedCi.getId(), rawDeployedCi.getClass(), this.baseJavaType});
            throw new InternalPluginException("Found CI that matches CI type criteria (deployed and container) that doesn't match java template type (generics)");
        }
        this.callInstall(context, rawDeployedCi, delta);
    }

    protected void processUpdateOfCi(Delta delta, DeploymentPlanningContext context) {
        Validate.notNull((Object)delta);
        Validate.notNull((Object)context);
        Deployed rawDeployedCi = delta.getDeployed();
        Deployed rawPreviousCi = delta.getPrevious();
        LOGGER.trace("Called to handle update request for CI with id [{}]. Previous CI has id [{}]", (Object)rawDeployedCi.getId(), (Object)rawPreviousCi);
        boolean deployedCiValid = this.matchesCiTypeCriteria(rawDeployedCi);
        boolean previousCiValid = this.matchesCiTypeCriteria(rawPreviousCi);
        if (deployedCiValid && previousCiValid) {
            if (rawDeployedCi.getContainer().equals(rawPreviousCi.getContainer())) {
                LOGGER.trace("Previous and target CI [{}] do have the same container. Perform an update.", (Object)rawDeployedCi.getId());
                this.callUpdate(context, rawDeployedCi, rawPreviousCi, delta);
            } else {
                LOGGER.trace("Previous and target CI [{}] don't have the same container. Cannot perform an update for different containers. Perform an uninstall and install instead.", (Object)rawDeployedCi.getId());
                this.callUninstall(context, rawPreviousCi, delta);
                this.callInstall(context, rawDeployedCi, delta);
            }
        } else if (deployedCiValid && !previousCiValid) {
            LOGGER.trace("Previous CI [{}] is not a valid portlet deployed archive. Perform an install only...", (Object)rawDeployedCi.getId());
            this.callInstall(context, rawDeployedCi, delta);
        } else if (!deployedCiValid && previousCiValid) {
            LOGGER.trace("Target CI [{}] is not a valid portlet deployed archive. Perform an uninstall only...", (Object)rawDeployedCi.getId());
            this.callUninstall(context, rawPreviousCi, delta);
        }
    }

    protected void processUninstallationOfCi(Delta delta, DeploymentPlanningContext context) {
        Validate.notNull((Object)delta);
        Validate.notNull((Object)context);
        Deployed rawPreviousCi = delta.getPrevious();
        LOGGER.trace("Called to handle uninstall request for CI with id [{}]", (Object)rawPreviousCi.getId());
        if (!this.matchesCiTypeCriteria(rawPreviousCi)) {
            LOGGER.trace("CI [{}] doesn't match criteria, skip it...", (Object)rawPreviousCi.getId());
            return;
        }
        this.callUninstall(context, rawPreviousCi, delta);
    }

    protected boolean matchesCiTypeCriteria(Deployed<?, ?> ciToValidate) {
        Validate.notNull(ciToValidate, (String)"CI to validate cannot be NULL");
        return TypeHelper.isInstanceOf(ciToValidate.getType(), this.targetCiType) && TypeHelper.isInstanceOf(ciToValidate.getContainer().getType(), this.targetContainerType);
    }

    protected final void callInstall(DeploymentPlanningContext context, Deployed<?, ?> rawDeployedCi, Delta delta) {
        if (!this.baseJavaType.isInstance(rawDeployedCi)) {
            LOGGER.error("Unable to process CI [{}]. CI class [{}] doesn't match required (generics) type [{}]", new Object[]{rawDeployedCi.getId(), rawDeployedCi.getClass(), this.baseJavaType});
            throw new InternalPluginException("Found CI that matches CI type criteria (deployed and container) that doesn't match java template type (generics)");
        }
        Deployed typedDeployedCi = (Deployed)this.baseJavaType.cast(rawDeployedCi);
        LOGGER.debug("Add steps to install CI with id [{}]", (Object)rawDeployedCi.getId());
        this.install(typedDeployedCi, context, delta);
    }

    protected final void callUpdate(DeploymentPlanningContext context, Deployed<?, ?> rawDeployedCi, Deployed<?, ?> rawPreviousCi, Delta delta) {
        if (!this.baseJavaType.isInstance(rawDeployedCi)) {
            LOGGER.error("Unable to process CI [{}]. CI class [{}] doesn't match required (generics) type [{}]", new Object[]{rawDeployedCi.getId(), rawDeployedCi.getClass(), this.baseJavaType});
            throw new InternalPluginException("Found CI that matches CI type criteria (deployed and container) that doesn't match java template type (generics)");
        }
        if (!this.baseJavaType.isInstance(rawPreviousCi)) {
            LOGGER.error("Unable to process CI [{}]. CI class [{}] doesn't match required (generics) type [{}]", new Object[]{rawPreviousCi.getId(), rawPreviousCi.getClass(), this.baseJavaType});
            throw new InternalPluginException("Found CI that matches CI type criteria (previous deployed CI and container) that doesn't match java template type (generics)");
        }
        Deployed typedDeployedCi = (Deployed)this.baseJavaType.cast(rawDeployedCi);
        Deployed typedPreviousCi = (Deployed)this.baseJavaType.cast(rawPreviousCi);
        LOGGER.debug("Add steps to install CI with id [{}]", (Object)rawDeployedCi.getId());
        this.update(typedDeployedCi, typedPreviousCi, context, delta);
    }

    protected final void callUninstall(DeploymentPlanningContext context, Deployed<?, ?> rawPreviousCi, Delta delta) {
        if (!this.baseJavaType.isInstance(rawPreviousCi)) {
            LOGGER.error("Unable to process CI [{}]. CI class [{}] doesn't match required (generics) type [{}]", new Object[]{rawPreviousCi.getId(), rawPreviousCi.getClass(), this.baseJavaType});
            throw new InternalPluginException("Found CI that matches CI type criteria (previous deployed CI and container) that doesn't match java template type (generics)");
        }
        Deployed typedPreviousCi = (Deployed)this.baseJavaType.cast(rawPreviousCi);
        LOGGER.debug("Add steps to uninstall CI with id [{}]", (Object)rawPreviousCi.getId());
        this.uninstall(typedPreviousCi, context, delta);
    }

    protected abstract void install(D var1, DeploymentPlanningContext var2, Delta var3);

    protected abstract void update(D var1, D var2, DeploymentPlanningContext var3, Delta var4);

    protected abstract void uninstall(D var1, DeploymentPlanningContext var2, Delta var3);
}

