/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed;

import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecurityLevel;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubject;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubjectType;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.AbstractAclMapping;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Metadata(description="Define ACL mapping for users and groups", root=Metadata.ConfigurationItemRoot.NESTED)
public class BaseAclMapping
extends AbstractAclMapping {
    @Property(label="Security level", description="Set the security level for this mapping.", required=true)
    private PortalSecurityLevel securityLevel;
    @Property(label="Users", description="Define set of users for this mapping", required=false)
    private Set<String> users;
    @Property(label="Groups", description="Define set of groups for this mapping", required=false)
    private Set<String> groups;

    public PortalSecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(PortalSecurityLevel securityLevel) {
        this.securityLevel = securityLevel;
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public void setUsers(Set<String> users) {
        this.users = users != null ? users : new HashSet<String>();
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups != null ? groups : new HashSet<String>();
    }

    @Override
    public Map<PortalSecurityLevel, Set<PortalSecuritySubject>> getMapping() {
        HashSet<PortalSecuritySubject> subjects = new HashSet<PortalSecuritySubject>(this.users.size() + this.groups.size());
        for (String user : this.users) {
            subjects.add(new PortalSecuritySubject(user, PortalSecuritySubjectType.USER));
        }
        for (String group : this.groups) {
            subjects.add(new PortalSecuritySubject(group, PortalSecuritySubjectType.GROUP));
        }
        HashMap<PortalSecurityLevel, Set<PortalSecuritySubject>> mapping = new HashMap<PortalSecurityLevel, Set<PortalSecuritySubject>>();
        mapping.put(this.securityLevel, subjects);
        return mapping;
    }
}

