/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.ci.portlet.model;

import com.crossingchannels.portal.websphere.ci.portlet.model.Portlet;
import com.crossingchannels.portal.websphere.ci.portlet.model.PortletApplication;
import com.crossingchannels.portal.websphere.ci.portlet.model.PortletBuilder;
import com.crossingchannels.portal.websphere.model.AbstractModelElementFactory;
import com.crossingchannels.portal.websphere.specification.jsr286.PortletDescriptor;
import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.BasePortlet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PortletApplicationBuilder
extends AbstractModelElementFactory<PortletApplication> {
    private final PortletDescriptor portletDescriptor;
    private Set<BasePortlet<?, ?>> portlets;
    private boolean autoScanForPortlets;

    public static PortletApplicationBuilder create(PortletDescriptor portletDescriptor) {
        return new PortletApplicationBuilder(portletDescriptor);
    }

    private PortletApplicationBuilder(PortletDescriptor portletDescriptor) {
        this.portletDescriptor = portletDescriptor;
    }

    @Override
    public PortletApplication toModel() {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        Map<String, BasePortlet<?, ?>> portletMap = this.buildPortletMap();
        for (String portletName : this.portletDescriptor.getPortletNames()) {
            if (!this.autoScanForPortlets && !portletMap.containsKey(portletName)) continue;
            portlets.add(PortletBuilder.create(portletName).setCi(portletMap.get(portletName)).toModel());
        }
        return new PortletApplication(this.portletDescriptor.getName(), this.portletDescriptor.getUniqueIdentifier(), portlets);
    }

    public PortletApplicationBuilder withPortlets(Set<BasePortlet<?, ?>> portlets, boolean autoScanForPortlets) {
        this.portlets = portlets;
        this.autoScanForPortlets = autoScanForPortlets;
        return this;
    }

    private Map<String, BasePortlet<?, ?>> buildPortletMap() {
        HashMap portletMap = new HashMap();
        for (BasePortlet<?, ?> portlet : this.portlets) {
            String name = (String)portlet.getProperty("portletName");
            portletMap.put(name, portlet);
        }
        return portletMap;
    }
}

