package com.crossingchannels.portal.websphere.ci.base.container;

import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;

/**
 * Wrapper class to enforce any python container wrapper to run in non-daemon mode.
 * 
 * @author FWiegerinck
 */
@SuppressWarnings({"serial", "deprecation"})
public class EnforceNonDaemonPythonContainerWrapper implements PythonManagingContainer {

    private final PythonManagingContainer wrappedObject;

    @Override
    public Set<String> getTags() {
        return this.wrappedObject.getTags();
    }

    @Override
    public void setTags(final Set<String> tags) {
        this.wrappedObject.setTags(tags);
    }

    @Override
    public String getId() {
        return this.wrappedObject.getId();
    }

    @Override
    public void setId(final String id) {
        this.wrappedObject.setId(id);
    }

    @Override
    public String getName() {
        return this.wrappedObject.getName();
    }

    @Override
    public Type getType() {
        return this.wrappedObject.getType();
    }

	@Override
    public Map<String, Object> getSyntheticProperties() {
        return this.wrappedObject.getSyntheticProperties();
    }

    @Override
    public <T> T getSyntheticProperty(final String key) {
        return this.wrappedObject.getSyntheticProperty(key);
    }

    @Override
    public <T> void putSyntheticProperty(final String key, final T value) {
        this.wrappedObject.putSyntheticProperty(key, value);
    }

    @Override
    public <T> T getProperty(final String key) {
        return this.wrappedObject.getProperty(key);
    }

    @Override
    public boolean hasProperty(final String key) {
        return this.wrappedObject.hasProperty(key);
    }

    @Override
    public <T> void setProperty(final String key, final T value) {
        this.wrappedObject.setProperty(key, value);
    }

    @Override
    public Host getHost() {
        return this.wrappedObject.getHost();
    }

    @Override
    public String getRuntimePath() {
        return this.wrappedObject.getRuntimePath();
    }

    @Override
    public boolean runWithDaemon() {
        return false;
    }

    @Override
    public CmdLine getScriptCommandLine(final OverthereFile script) {
        return this.wrappedObject.getScriptCommandLine(script);
    }

    /**
     * @param wrappedObject
     */
    public EnforceNonDaemonPythonContainerWrapper(final PythonManagingContainer wrappedObject) {
        super();
        this.wrappedObject = wrappedObject;
    }

}
