package com.crossingchannels.portal.websphere.ci.generic.types;

/**
 * Define set of possible subject types of a user.
 * @author fwiegerinck
 */
public enum PortalSecuritySubjectType {

	/**
	 * Define support for a user.
	 */
	USER("user"),
	
	/**
	 * Define support for a user group.
	 */
	GROUP("USER_GROUP");
	
	/**
	 * Define name used by xmlAccess.
	 */
	private final String xmlAccessName;
	
	/**
	 * Initialize new security subject type.
	 * @param xmlAccessName The XML Access representation assigned to this subject type.
	 */
	PortalSecuritySubjectType(final String xmlAccessName) {
		this.xmlAccessName = xmlAccessName;
	}
	
	/**
	 * Get the XML Access representation/name of the security subject type.
	 * 
	 * @return The XML Access representations.
	 */
	public String getXmlAccessName() {
		return xmlAccessName;
	}
	
	
}
