package com.crossingchannels.portal.websphere.ci.portlet.model;

import com.crossingchannels.portal.websphere.model.AbstractModelElementFactory;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;

import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.BasePortlet;

/**
 * Builder to create different types of model elements
 * 
 * @author FWiegerinck
 */
public class ClonedPortletBuilder extends AbstractModelElementFactory<ClonedPortlet> {

    public static ClonedPortletBuilder create() {
        return new ClonedPortletBuilder();
    }

    private BasePortlet<?, ?> deployedClonedPortletCi;

    /**
     * Hide constructor for utility/builder class
     */
    private ClonedPortletBuilder() {
        super();
    }
    
    public ClonedPortletBuilder setCi(BasePortlet<?, ?> deployedClonedPortletCi) {
    	this.deployedClonedPortletCi = deployedClonedPortletCi;
    	
    	return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ClonedPortlet toModel() {
    	final BasePortlet<?, ?> portletCi;
    	if ( this.deployedClonedPortletCi == null  ) {
    		portletCi = DescriptorRegistry.getDescriptor("wp.ClonedPortlet").newInstance();
    	} else {
    		portletCi = this.deployedClonedPortletCi; 
    	}
    	
        // Do generate items
        return new ClonedPortlet(portletCi);
    }
}
