package com.crossingchannels.portal.websphere.template;

/**
 * Exception thrown if an error occurs while parsing a template.
 * 
 * @author FWiegerinck
 */
@SuppressWarnings("serial")
public class TemplateParseException extends Exception {

    /**
     * Template for the description of the exception.
     */
    private static final String EXCEPTION_DESCRIPTION = "Exception occurred while parsing template [%s]";

    /**
     * Build a new description for this exception using the template <code>EXCEPTION_DESCRIPTION</code>.
     * 
     * @param templateName
     *            Name of the template to parse.
     * @return A formatted description.
     */
    private static final String buildDescription(final String templateName) {
        return String.format(TemplateParseException.EXCEPTION_DESCRIPTION, templateName);
    }

    /**
     * Initialize new template parse exception.
     * 
     * @param templateName
     *            Name of the template to parse.
     * @param cause
     *            The wrapped exception describing the cause of the error.
     */
    public TemplateParseException(final String templateName, final Throwable cause) {
        super(TemplateParseException.buildDescription(templateName), cause);
    }

}
