package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container;

import com.crossingchannels.portal.websphere.ci.generic.container.WpVersion;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.was.container.WasAppContainer;

/**
 * Tagging interface for a runtime container to contain portal resources.
 * 
 * @author fwiegerinck
 */
@Metadata(virtual = true, root = ConfigurationItemRoot.INFRASTRUCTURE)
public interface WpRuntimeContainer extends WpContainer, HostContainer, PythonManagedContainer, WasAppContainer {

    /**
     * Retrieve the WebSphere Portal administrator password.
     * 
     * @return The password of the WebSphere Portal administrator.
     */
    String getWpAdminPassword();

    /**
     * Retrieve the WebSphere Portal administrator username.
     * 
     * @return The username of the WebSphere Portal administrator.
     */
    String getWpAdminUsername();

    /**
     * Retrieve the WebSphere Portal Home directory on the primary node.
     * 
     * @return A local path on the primary node.
     */
    String getWpHome();

    /**
     * Retrieve the WebSphere Portal version of the container.
     * 
     * @return The WebSphere Portal version.
     */
    WpVersion getWpVersion();

}
