package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.deployable;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFolderArtifact;

/**
 * BaseDeployableArtifact resource that is installed using XML access
 * 
 * @author fwiegerinck
 */
@Metadata(virtual = false, description = "Set of XML access scripts to configure WebSphere Portal")
@SuppressWarnings("serial")
public class DeployableXmlAccessScript extends BaseDeployableFolderArtifact {

    @Property(hidden = false, label = "Create script", description = "XML Access Script used to install. Also used during update if no update script is specified.", defaultValue = "install.xml", category = "Advanced")
    private String createScript;

    @Property(hidden = false, label = "Destroy script", description = "XML Access Script used to uninstall. Also used during update if no update script is specified.", defaultValue = "uninstall.xml", category = "Advanced", required = false)
    private String destroyScript;

    @Property(hidden = false, label = "Modify script", description = "XML Access Script used to update from a previous version.", category = "Advanced", required = false)
    private String modifyScript;
    
    @Property(hidden = true, label = "Order of creation", defaultValue = "50")
    private int createOrder;

    @Property(hidden = true, label = "Order of destruction", defaultValue = "50", required = false)
    private int destroyOrder;

    @Property(hidden = true, label = "Order of modification", defaultValue = "50", required = false)
    private int modifyOrder;

	public String getCreateScript() {
		return createScript;
	}

	public void setCreateScript(String create) {
		this.createScript = create;
	}

	public String getDestroyScript() {
		return destroyScript;
	}

	public void setDestroyScript(String destroy) {
		this.destroyScript = destroy;
	}

	public String getModifyScript() {
		return modifyScript;
	}

	public void setModifyScript(String modify) {
		this.modifyScript = modify;
	}

	public int getCreateOrder() {
		return createOrder;
	}

	public void setCreateOrder(int createOrder) {
		this.createOrder = createOrder;
	}

	public int getDestroyOrder() {
		return destroyOrder;
	}

	public void setDestroyOrder(int destroyOrder) {
		this.destroyOrder = destroyOrder;
	}

	public int getModifyOrder() {
		return modifyOrder;
	}

	public void setModifyOrder(int modifyOrder) {
		this.modifyOrder = modifyOrder;
	}    

}
