package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.crossingchannels.portal.websphere.ci.base.container.EnforceNonDaemonPythonContainerWrapper;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.DefaultProcessOutputHandler;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.MultipleOverthereProcessOutputHandler;

/**
 * @author FWiegerinck
 * 
 */
@SuppressWarnings("serial")
public class DetermineWebArchiveInstallationRootStep extends PythonDeploymentStep {

    /**
     * Define logger for this class.
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(DetermineWebArchiveInstallationRootStep.class);

    public static final String PROPERTY_INSTALL_ROOT = "installLocation";

    private static final String OUTPUT_PREFIX = "binariesURL=";

    /**
     * Define name of the CI-property containing the unregister XML Access Script.
     */
    private static final String PROPERTY_DETECT_INSTALLROOT_SCRIPT = "detectInstallRootScript";

    /**
     * Define name of the CI-property containing the order to run the unregister script.
     */
    private static final String PROPERTY_DETECT_INSTALLROOT_ORDER = "detectInstallRootOrder";

    private final ExtensibleDeployedArtifact deployedArtifact;

    private final PythonManagedContainer container;

    private String installLocation;

    /**
     * @param container
     * @param deployedArtifact
     */
    public DetermineWebArchiveInstallationRootStep(final PythonManagedContainer container, final ExtensibleDeployedArtifact deployedArtifact) {
        super(
        		deployedArtifact.<Integer> getProperty(PROPERTY_DETECT_INSTALLROOT_ORDER), 
        		new EnforceNonDaemonPythonContainerWrapper(container.getManagingContainer()),
        		deployedArtifact.<String> getProperty(PROPERTY_DETECT_INSTALLROOT_SCRIPT), 
        		DetermineWebArchiveInstallationRootStep.getPythonVars(deployedArtifact),
        		DetermineWebArchiveInstallationRootStep.buildDescription(deployedArtifact)
        	);

        this.deployedArtifact = deployedArtifact;
        this.container = container;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        this.installLocation = null;
        final StepExitCode res = this.doExecute(ctx);
        if (res == StepExitCode.SUCCESS) {

            if (this.installLocation != null) {
                this.deployedArtifact.setProperty(DetermineWebArchiveInstallationRootStep.PROPERTY_INSTALL_ROOT, this.installLocation);

                ctx.logOutput(String.format("Found installation directory '%s' for deployed artifact %s", this.installLocation, this.deployedArtifact.getId()));
            } else {
                ctx.logError(String.format("Unable to determine installation directory for deployed artifact %s", this.deployedArtifact.getName()));
                return StepExitCode.FAIL;
            }
        }
        return res;
    }

    @Override
    protected int executePythonScriptDirectly(final ExecutionContext ctx, final OverthereConnection conn, final OverthereFile script) {
        DetermineWebArchiveInstallationRootStep.LOGGER.info("Executing Python script {} on {} (without daemon)", script, conn);

        final DefaultProcessOutputHandler executionContextOutputHandler = new DefaultProcessOutputHandler(ctx);
        try {
            final CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
            final MultipleOverthereProcessOutputHandler outputHandlers = MultipleOverthereProcessOutputHandler.multiHandler(capturedOutput, executionContextOutputHandler);

            final int result = conn.execute(outputHandlers, this.container.getManagingContainer().getScriptCommandLine(script));

            this.installLocation = null;
            DetermineWebArchiveInstallationRootStep.LOGGER.trace("Amount of outputlines from jython: {}", capturedOutput.getOutputLines().size());
            for (final String outputLine : capturedOutput.getOutputLines()) {
                if (outputLine.trim().startsWith(DetermineWebArchiveInstallationRootStep.OUTPUT_PREFIX)) {
                    DetermineWebArchiveInstallationRootStep.LOGGER.trace("Use outputline to get value: {}", outputLine);

                    this.installLocation = outputLine.substring(DetermineWebArchiveInstallationRootStep.OUTPUT_PREFIX.length());

                } else {
                    DetermineWebArchiveInstallationRootStep.LOGGER.trace("Skip outputline: {}", outputLine);
                }

            }

            return result;
        } finally {
            executionContextOutputHandler.close();
        }
    }

    protected static Map<String, Object> getPythonVars(final ExtensibleDeployedArtifact deployedArtifact) {
        final Map<String, Object> pythonVars = Maps.newHashMap();
        pythonVars.put("deployed", deployedArtifact);
        return pythonVars;
    }

    protected static String buildDescription(final ExtensibleDeployedArtifact deployedArtifact) {
        return String.format("Determine installation root for application: %s", deployedArtifact.getName());
    }

}
