package ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.contributor;

import com.crossingchannels.portal.websphere.ci.base.contributor.AbstractWasArtifactStepsContributor;
import com.crossingchannels.portal.websphere.ci.portlet.step.AbstractPortletApplicationActionStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;

import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step.DetermineWebArchiveInstallationRootStep;
import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.step.PortletEnterpriseApplicationActionStep;

/**
 * Contributor to add additional steps if a EAR file with portlets are installed.
 * 
 * @author fwiegerinck
 * @since 1.1
 * @version 1.1
 */
public class PortletEarStepsContributor extends AbstractWasArtifactStepsContributor {

    /**
     * Resolve type definition for a portlet Ear.
     */
    private static final Type PORTLETEAR = Type.valueOf("wp.EarModule");

    /**
     * Initialize a new installation steps contributor for Portlet EARs
     */
    public PortletEarStepsContributor() {
        super(PortletEarStepsContributor.PORTLETEAR);
    }

    // Override to trigger autodetection
    @Override
    @Contributor
    public void contributePortletSteps(final Deltas deltas, final DeploymentPlanningContext context) {
        super.contributePortletSteps(deltas, context);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void install(final ExtensibleDeployedArtifact artifactToInstall, final DeploymentPlanningContext context, final Delta delta) {

        // Add required steps
    	context.addStep(
    			new DetermineWebArchiveInstallationRootStep(artifactToInstall.getContainer(), artifactToInstall)
    		);    	
        context.addStep(
        		new PortletEnterpriseApplicationActionStep(
        				artifactToInstall.<String> getProperty(AbstractPortletApplicationActionStep.PROPERTY_REGISTER_SCRIPT), 
        				artifactToInstall,
                		artifactToInstall.<Integer> getProperty(AbstractPortletApplicationActionStep.PROPERTY_REGISTER_ORDER)
                	)
            );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void update(final ExtensibleDeployedArtifact newArtifact, final ExtensibleDeployedArtifact oldArtifact, final DeploymentPlanningContext context, final Delta delta) {

        // Add required steps
    	context.addStep(
    			new DetermineWebArchiveInstallationRootStep(newArtifact.getContainer(), newArtifact)
    		);    	
        context.addStep(
        		new PortletEnterpriseApplicationActionStep(
        				newArtifact.<String> getProperty(AbstractPortletApplicationActionStep.PROPERTY_REGISTER_SCRIPT),
        				newArtifact,
        				newArtifact.<Integer> getProperty(AbstractPortletApplicationActionStep.PROPERTY_REGISTER_ORDER)
        			)
            );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void uninstall(final ExtensibleDeployedArtifact artifactToUninstall, final DeploymentPlanningContext context, final Delta delta) {
        // Add required steps
        context.addStep(
        		new PortletEnterpriseApplicationActionStep(
        				artifactToUninstall.<String> getProperty(AbstractPortletApplicationActionStep.PROPERTY_UNREGISTER_SCRIPT),
        				artifactToUninstall,
        				artifactToUninstall.<Integer> getProperty(AbstractPortletApplicationActionStep.PROPERTY_UNREGISTER_ORDER)
        			)
        );
    }

}
