package ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed;

import java.util.Map;
import java.util.Set;

import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecurityLevel;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubject;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot;
import com.xebialabs.deployit.plugin.api.udm.base.BaseEmbeddedDeployed;

@SuppressWarnings({ "serial", "rawtypes" })
@Metadata(virtual = true, description = "Base definition for ACL mappings", root=ConfigurationItemRoot.NESTED)
public abstract class AbstractAclMapping extends BaseEmbeddedDeployed<EmbeddedDeployable, BasePortlet> {

	/**
	 * Get the mapping defined by this ACL mapping.
	 * @return Map with the mapping details.
	 */
	public abstract Map<PortalSecurityLevel, Set<PortalSecuritySubject>> getMapping();
}
