package ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecurityLevel;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubject;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubjectType;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot;

@SuppressWarnings("serial")
@Metadata(description = "Define ACL mapping for virtual users and groups", root=ConfigurationItemRoot.NESTED)
public class BaseVirtualUserAndGroupsAclMapping extends AbstractAclMapping {

	/**
	 * Define constant for special subject: anonymous portal user.
	 */
	private static final PortalSecuritySubject SUBJECT_ANONYMOUS_PORTAL_USER = new PortalSecuritySubject("anonymous portal user", PortalSecuritySubjectType.USER);
	
	/**
	 * Define constant for special subject: all authenticated portal users.
	 */
	private static final PortalSecuritySubject SUBJECT_ALL_AUTHENTICATED_PORTAL_USERS = new PortalSecuritySubject("all authenticated portal users", PortalSecuritySubjectType.USER);

	/**
	 * Define constant for special subject: all portal user groups.
	 */
	private static final PortalSecuritySubject SUBJECT_ALL_PORTAL_USER_GROUPS = new PortalSecuritySubject("all portal user groups", PortalSecuritySubjectType.GROUP);

	@Property(label = "Anonymous Portal User", category="Security", description="Set the security level for anonymous portal users.", required=true)
	private PortalSecurityLevel securityLevelForAnonymousPortalUser = PortalSecurityLevel.NONE;
	
	@Property(label = "All Authenticated Portal Users", category="Security", description="Set the security level for all authenticated portal users.", required=true)
	private PortalSecurityLevel securityLevelForAllAuthenticatedPortalUsers = PortalSecurityLevel.NONE;

	@Property(label = "All Portal User Groups", category="Security", description="Set the security level for all portal users groups.", required=true)
	private PortalSecurityLevel securityLevelForAllPortalUserGroups = PortalSecurityLevel.NONE;

	public PortalSecurityLevel getSecurityLevelForAnonymousPortalUser() {
		return securityLevelForAnonymousPortalUser;
	}

	public void setSecurityLevelForAnonymousPortalUser(
			PortalSecurityLevel securityLevelForAnonymousPortalUser) {
		this.securityLevelForAnonymousPortalUser = securityLevelForAnonymousPortalUser;
	}

	public PortalSecurityLevel getSecurityLevelForAllAuthenticatedPortalUsers() {
		return securityLevelForAllAuthenticatedPortalUsers;
	}

	public void setSecurityLevelForAllAuthenticatedPortalUsers(
			PortalSecurityLevel securityLevelForAllAuthenticatedPortalUsers) {
		this.securityLevelForAllAuthenticatedPortalUsers = securityLevelForAllAuthenticatedPortalUsers;
	}

	public PortalSecurityLevel getSecurityLevelForAllPortalUserGroups() {
		return securityLevelForAllPortalUserGroups;
	}

	public void setSecurityLevelForAllPortalUserGroups(
			PortalSecurityLevel securityLevelForAllPortalUserGroups) {
		this.securityLevelForAllPortalUserGroups = securityLevelForAllPortalUserGroups;
	}

	@Override
	public Map<PortalSecurityLevel, Set<PortalSecuritySubject>> getMapping() {
		
		final Map<PortalSecurityLevel, Set<PortalSecuritySubject>> mapping = new HashMap<PortalSecurityLevel, Set<PortalSecuritySubject>>();

		this.addMapping(mapping, BaseVirtualUserAndGroupsAclMapping.SUBJECT_ANONYMOUS_PORTAL_USER, this.securityLevelForAnonymousPortalUser);
		this.addMapping(mapping, BaseVirtualUserAndGroupsAclMapping.SUBJECT_ALL_AUTHENTICATED_PORTAL_USERS, this.securityLevelForAllAuthenticatedPortalUsers);
		this.addMapping(mapping, BaseVirtualUserAndGroupsAclMapping.SUBJECT_ALL_PORTAL_USER_GROUPS, this.securityLevelForAllPortalUserGroups);
		
		return mapping;
	}

	private void addMapping(
			final Map<PortalSecurityLevel, Set<PortalSecuritySubject>> mapping,
			final PortalSecuritySubject subject,
			final PortalSecurityLevel securityLevel) {

		// Get existing set of subjects, or create a new item
		final Set<PortalSecuritySubject> portalSecuritySubjects;
		if ( mapping.containsKey(securityLevel) ) {
			portalSecuritySubjects = mapping.get(securityLevel);
		} else {
			portalSecuritySubjects = new HashSet<PortalSecuritySubject>();
			mapping.put(securityLevel, portalSecuritySubjects);
		}
		
		// Update set of subjects
		portalSecuritySubjects.add(subject);
	}
	

}
