package ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.step;

import com.crossingchannels.portal.websphere.ci.portlet.model.PortletArchive;
import com.crossingchannels.portal.websphere.ci.portlet.model.PortletArchiveBuilder;
import com.crossingchannels.portal.websphere.ci.portlet.step.AbstractPortletApplicationActionStep;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;

/**
 * Step to handle all portlet EAR application actions (install, update or uninstall).
 * 
 * @author FWiegerinck
 */
@SuppressWarnings("serial")
public class PortletEnterpriseApplicationActionStep extends AbstractPortletApplicationActionStep {

	/**
	 * Initialize a new step to execute XML access specified by <code>script</code> to modify the CI <code>artifactToChange</code>. The step order is specified by <code>order</code>.
	 * 
     * @param script XML Access script to execute.
     * @param artifactToChange The CI artifact to change.
     * @param order The steps order.
     */
    public PortletEnterpriseApplicationActionStep(final String script, final ExtensibleDeployedArtifact artifactToChange, final int order) {
        super(script, artifactToChange, order);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected PortletArchive buildModel(final ExtensibleDeployedArtifact artifactToInstal) {
        return PortletArchiveBuilder.fromEar(artifactToInstal).toModel();
    }
}
