/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step;

import com.crossingchannels.portal.websphere.ci.base.container.EnforceNonDaemonPythonContainerWrapper;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.DefaultProcessOutputHandler;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.MultipleOverthereProcessOutputHandler;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetermineWebArchiveInstallationRootStep
extends PythonDeploymentStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetermineWebArchiveInstallationRootStep.class);
    public static final String PROPERTY_INSTALL_ROOT = "installLocation";
    private static final String OUTPUT_PREFIX = "binariesURL=";
    private static final String PROPERTY_DETECT_INSTALLROOT_SCRIPT = "detectInstallRootScript";
    private static final String PROPERTY_DETECT_INSTALLROOT_ORDER = "detectInstallRootOrder";
    private final ExtensibleDeployedArtifact deployedArtifact;
    private final PythonManagedContainer container;
    private String installLocation;

    public DetermineWebArchiveInstallationRootStep(PythonManagedContainer container, ExtensibleDeployedArtifact deployedArtifact) {
        super(((Integer)deployedArtifact.getProperty(PROPERTY_DETECT_INSTALLROOT_ORDER)).intValue(), (PythonManagingContainer)new EnforceNonDaemonPythonContainerWrapper(container.getManagingContainer()), (String)deployedArtifact.getProperty(PROPERTY_DETECT_INSTALLROOT_SCRIPT), DetermineWebArchiveInstallationRootStep.getPythonVars(deployedArtifact), DetermineWebArchiveInstallationRootStep.buildDescription(deployedArtifact));
        this.deployedArtifact = deployedArtifact;
        this.container = container;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        this.installLocation = null;
        StepExitCode res = this.doExecute(ctx);
        if (res == StepExitCode.SUCCESS) {
            if (this.installLocation != null) {
                this.deployedArtifact.setProperty(PROPERTY_INSTALL_ROOT, (Object)this.installLocation);
                ctx.logOutput(String.format("Found installation directory '%s' for deployed artifact %s", this.installLocation, this.deployedArtifact.getId()));
            } else {
                ctx.logError(String.format("Unable to determine installation directory for deployed artifact %s", this.deployedArtifact.getName()));
                return StepExitCode.FAIL;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executePythonScriptDirectly(ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        LOGGER.info("Executing Python script {} on {} (without daemon)", (Object)script, (Object)conn);
        try (DefaultProcessOutputHandler executionContextOutputHandler = new DefaultProcessOutputHandler(ctx);){
            CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
            MultipleOverthereProcessOutputHandler outputHandlers = MultipleOverthereProcessOutputHandler.multiHandler((OverthereProcessOutputHandler[])new OverthereProcessOutputHandler[]{capturedOutput, executionContextOutputHandler});
            int result = conn.execute((OverthereProcessOutputHandler)outputHandlers, this.container.getManagingContainer().getScriptCommandLine(script));
            this.installLocation = null;
            LOGGER.trace("Amount of outputlines from jython: {}", (Object)capturedOutput.getOutputLines().size());
            for (String outputLine : capturedOutput.getOutputLines()) {
                if (outputLine.trim().startsWith(OUTPUT_PREFIX)) {
                    LOGGER.trace("Use outputline to get value: {}", (Object)outputLine);
                    this.installLocation = outputLine.substring(OUTPUT_PREFIX.length());
                    continue;
                }
                LOGGER.trace("Skip outputline: {}", (Object)outputLine);
            }
            int n = result;
            return n;
        }
    }

    protected static Map<String, Object> getPythonVars(ExtensibleDeployedArtifact deployedArtifact) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("deployed", deployedArtifact);
        return pythonVars;
    }

    protected static String buildDescription(ExtensibleDeployedArtifact deployedArtifact) {
        return String.format("Determine installation root for application: %s", deployedArtifact.getName());
    }
}

